package im.qingtui.qbee.open.platfrom.portal.model.param.employee;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 创建员工请求参数
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class CreateEmployeeParam implements Serializable {

    /**
     * 员工帐号
     */
    String account;
    /**
     * 帐号密码
     */
    String password;
    /**
     * 员工名称
     */
    String name;
    /**
     * 员工性别(1-男,2-女)
     */
    Integer gender;
    /**
     * 员工所属组织机构id
     */
    String orgId;
    /**
     * 员工邮箱
     */
    String email;
    /**
     * 员工工号
     */
    String employeeNo;
    /**
     * 员工手机号码
     */
    String mobile;
    /**
     * 员工编码 2020、12、14  新增
     */
    String employeeCode;

    /**
     * 员工类型 2020、12、14  新增
     */
    String employeeTypeId;

    /**
     * 角色id列表2020、12、14  新增
     */
    List<String> roleIdList = new ArrayList<>();
    /**
     * 出生日期
     */
    Long gmtBirthday;
    /**
     * 入职日期
     */
    Long gmtEntry;
    /**
     * 第三方系统手机国际码
     */
    String thirdSystemCountryCode;
    /**
     * 第三方系统手机号
     */
    String thirdSystemMobile;
}