package im.qingtui.qbee.open.platfrom.portal.service;


import static im.qingtui.qbee.open.platfrom.portal.common.constants.UrlConstants.DUTY_LEVEL_ASSOCIATE_URL;
import static im.qingtui.qbee.open.platfrom.portal.common.constants.UrlConstants.DUTY_LEVEL_URL;
import static im.qingtui.qbee.open.platfrom.portal.common.constants.UrlConstants.DUTY_URL;
import static im.qingtui.qbee.open.platfrom.portal.common.constants.UrlConstants.GET_DUTY_LIST_URL;
import static im.qingtui.qbee.open.platfrom.portal.common.constants.UrlConstants.GET_DUTY_POSITION_URL;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.model.param.base.BaseKeywordParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseData;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseId;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BasePage;
import im.qingtui.qbee.open.platfrom.portal.model.param.duty.AddDutyParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.duty.CreateDutyParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.duty.DutyLevelIdParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.duty.EditDutyParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.duty.ModifyDutyParam;
import im.qingtui.qbee.open.platfrom.portal.model.vo.duty.DutyBaseInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.duty.DutyLevelInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.duty.DutyLevelParam;
import im.qingtui.qbee.open.platfrom.portal.model.vo.duty.DutyPositionInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.duty.IdVO;

/**
 * 职务相关接口
 *
 * @author shizhen
 */
public class DutyService {

    /**
     * 创建职务
     *
     * @param createDutyParam 创建职务参数
     * @return 创建的职务id
     */
    public static BaseData<BaseId> createDuty(CreateDutyParam createDutyParam) {
        return createDuty(createDutyParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseData<BaseId> createDuty(CreateDutyParam createDutyParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.postRequest(DUTY_URL, token, createDutyParam);
        return new BaseData<>(JSONObject.parseObject(baseHttpVO.getDataJson().toString(), BaseId.class));
    }

    /**
     * 删除职务
     *
     * @param id 职务id
     */
    public static void deleteDuty(String id) {
        deleteDuty(id, TokenUtils.getToken());
    }

    /**
     * 编辑职务
     *
     * @param editDutyParam 编辑职务参数
     */
    public static void editDuty(EditDutyParam editDutyParam) {
        editDuty(editDutyParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void editDuty(EditDutyParam editDutyParam, String token) {
        HttpClientRequestUtils.putRequest(DUTY_URL, token, editDutyParam);
    }

    /**
     * 根据职务id获取职务下的岗位信息列表
     *
     * @param id 职务id
     * @return 职务下的岗位信息列表
     */
    public static BasePage<DutyPositionInfo> getDutyPositionListByDutyId(String id) {
        return getDutyPositionListByDutyId(id, TokenUtils.getToken());
    }

    @Deprecated
    public static BasePage<DutyPositionInfo> getDutyPositionListByDutyId(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GET_DUTY_POSITION_URL, token, new BaseId(id));
        return HttpClientRequestUtils.converterToData(baseHttpVO, new TypeReference<BasePage<DutyPositionInfo>>() {
        });
    }

    @Deprecated
    public static void deleteDuty(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.deleteRequest(DUTY_URL, token, new BaseId(id));
    }

    /**
     * 根据职务id获取职务信息
     *
     * @param id 职务id
     * @return 查询的职务信息
     */
    public static BaseData<DutyBaseInfo> getDutyById(String id) {
        return getDutyById(id, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseData<DutyBaseInfo> getDutyById(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(DUTY_URL, token, new BaseId(id));
        return new BaseData<>(JSONObject.parseObject(baseHttpVO.getDataJson().toString(), DutyBaseInfo.class));
    }

    /**
     * 获取职务信息列表
     *
     * @param keyword 搜索关键字（职务名称）
     * @return 职务信息列表
     */
    public static BaseList<DutyBaseInfo> getDutyList(String keyword) {
        return getDutyList(keyword, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseList<DutyBaseInfo> getDutyList(String keyword, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GET_DUTY_LIST_URL, token, new BaseKeywordParam(keyword));
        return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<DutyBaseInfo>>() {
        });
    }

    /**
     * 新增职级
     *
     * @param param 职级实体
     */
    public static IdVO addDutyLevel(AddDutyParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.postRequest(DUTY_LEVEL_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.converterToData(baseHttpVO, new TypeReference<IdVO>() {
        });
    }

    /**
     * 删除职级信息
     *
     * @param param 职级实体
     */
    public static void deleteDutyLevel(DutyLevelIdParam param) {
        HttpClientRequestUtils.deleteRequest(DUTY_LEVEL_URL, TokenUtils.getToken(), param);
    }

    /**
     * 修改职级信息
     *
     * @param param 职级实体
     */
    public static void modifyDutyLevel(ModifyDutyParam param) {
        HttpClientRequestUtils.putRequest(DUTY_LEVEL_URL, TokenUtils.getToken(), param);
    }

    /**
     * 根据id查询职级信息
     *
     * @param param 职级实体
     */
    public static BasePage<DutyLevelInfo> listDutyLevel(DutyLevelIdParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(DUTY_LEVEL_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.converterToData(baseHttpVO, new TypeReference<BasePage<DutyLevelInfo>>() {
        });
    }

    /**
     * 在职务下新增职级信息
     *
     * @param param param
     */
    public static void addDutyLevelByDutyId(DutyLevelParam param) {
        HttpClientRequestUtils.postRequest(DUTY_LEVEL_ASSOCIATE_URL, TokenUtils.getToken(), param);
    }

    /**
     * 在职务下删除职级信息
     *
     * @param param param
     */
    public static void deleteDutyLevelByDutyId(DutyLevelParam param) {
        HttpClientRequestUtils.deleteRequest(DUTY_LEVEL_ASSOCIATE_URL, TokenUtils.getToken(), param);
    }
}