package im.qingtui.qbee.open.platfrom.portal.model.vo.duty;

import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import java.io.Serializable;
import java.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.FieldDefaults;

/**
 * 职务下的岗位信息返回信息
 *
 * @author shizhen
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class DutyPositionInfo extends BaseInfo implements Serializable {

    /**
     * 职务编码
     */
    String code;
    /**
     * 岗位下的人员数量
     */
    Integer memberCount;
    /**
     * 岗位所属组织机构列表
     */
    List<BaseInfo> orgList;

    @Override
    public String toString() {
        return "DutyPositionInfo{" +
            "code='" + code + '\'' +
            ", memberCount=" + memberCount +
            ", orgList=" + orgList +
            ", name=" + super.getName() +
            ", id=" + super.getId() +
            '}';
    }
}