package im.qingtui.qbee.open.platfrom.portal.model.param.position;

import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 分页获取岗位基础请求参数
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class PagePositionBaseParam implements Serializable {

    /**
     * 组织机构id
     */
    String orgId;
    /**
     * 分页大小（最大200）
     */
    Integer size;
    /**
     * 请求页数（从1开始）
     */
    Integer page;
}