package im.qingtui.qbee.open.platfrom.portal.service;

import static im.qingtui.qbee.open.platfrom.portal.common.constants.UrlConstants.BATCH_CREATE_ORG_URL;
import static im.qingtui.qbee.open.platfrom.portal.common.constants.UrlConstants.GET_ORG_LIST_BY_ORG_CODE_URL;
import static im.qingtui.qbee.open.platfrom.portal.common.constants.UrlConstants.GET_ORG_LIST_LIKE_ORG_NAME_URL;
import static im.qingtui.qbee.open.platfrom.portal.common.constants.UrlConstants.GET_ORG_LIST_URL;
import static im.qingtui.qbee.open.platfrom.portal.common.constants.UrlConstants.GET_ORG_TREE_BY_PATH_URL;
import static im.qingtui.qbee.open.platfrom.portal.common.constants.UrlConstants.GET_ORG_TREE_URL;
import static im.qingtui.qbee.open.platfrom.portal.common.constants.UrlConstants.ORG_URL;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.model.enums.HttpRequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseData;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseId;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseResult;
import im.qingtui.qbee.open.platfrom.portal.model.param.org.BatchCreateOrgParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.org.CreateOrgParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.org.EditOrgParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.org.GetOrgListParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.org.ListOrgInfoByOrgCodesParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.org.ListOrgLikeOrgNameParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.org.OrgPathParam;
import im.qingtui.qbee.open.platfrom.portal.model.vo.org.OrgBaseInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.org.OrgInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.org.OrgTree;

/**
 * 组织机构相关接口
 *
 * @author shizhen
 */
public class OrgService {

    /**
     * 新增组织机构
     *
     * @param createOrgParam 创建组织机构参数
     * @return 创建的组织机构id
     */
    public static BaseData<BaseId> createOrg(CreateOrgParam createOrgParam) {
        return createOrg(createOrgParam, TokenUtils.getToken());
    }

    /**
     * 批量新增组织机构
     *
     * @param batchCreateOrgParam 批量创建组织机构参数
     */
    public static void batchCreateOrg(BatchCreateOrgParam batchCreateOrgParam) {
        batchCreateOrg(batchCreateOrgParam, TokenUtils.getToken());
    }

    /**
     * 删除组织机构
     *
     * @param id 组织机构id
     */
    public static void deleteOrg(String id) {
        deleteOrg(id, TokenUtils.getToken());
    }

    /**
     * 修改组织机构
     *
     * @param editOrgParam 编辑组织机构参数
     */
    public static void editOrg(EditOrgParam editOrgParam) {
        editOrg(editOrgParam, TokenUtils.getToken());
    }

    /**
     * 通过id获取组织机构
     *
     * @param id 组织机构id
     * @return 查询的组织机构信息
     */
    public static BaseData<OrgInfo> getOrgById(String id) {
        return getOrgById(id, TokenUtils.getToken());
    }

    /**
     * 通过父级组织机构 id 获取下级组织机构
     *
     * @param getOrgListParam 获取组织机构列表参数
     * @return 查询的组织机构下的组织机构列表（只获取下一级子节点，非全部叶子节点）
     */
    public static BaseList<OrgInfo> getOrgList(GetOrgListParam getOrgListParam) {
        return getOrgList(getOrgListParam, TokenUtils.getToken());
    }


    /**
     * 获取组织机构树
     *
     * @return 组织机构树
     */
    public static BaseList<OrgTree> getOrgTree() {
        return getOrgTree(TokenUtils.getToken());
    }

    /**
     * 通过路径获取组织机构
     *
     * @param orgPathParam 组织机构路径参数
     * @return 组织机构节点信息
     */
    public static BaseList<OrgBaseInfo> getOrgListByOrgPath(OrgPathParam orgPathParam) {
        return getOrgListByOrgPath(orgPathParam, TokenUtils.getToken());
    }

    /**
     * 通过组织机构编码获取组织机构
     *
     * @param orgInfoByOrgCodesParam orgInfoByOrgCodesParam
     */
    public static BaseList<OrgInfo> listOrgInfoByOrgCodes(ListOrgInfoByOrgCodesParam orgInfoByOrgCodesParam) {
        return listOrgInfoByOrgCodes(orgInfoByOrgCodesParam, TokenUtils.getToken());
    }

    /**
     * 通过搜索获取组织机构信息
     *
     * @param param param
     * @return BaseList OrgInfo
     */
    public static BaseList<OrgInfo> listOrgInfoLikeOrgName(ListOrgLikeOrgNameParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GET_ORG_LIST_LIKE_ORG_NAME_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.converterToData(baseHttpVO, new TypeReference<BaseList<OrgInfo>>() {
        });
    }

    @Deprecated
    public static BaseList<OrgInfo> getOrgList(GetOrgListParam getOrgListParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GET_ORG_LIST_URL, token, getOrgListParam);
        return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<OrgInfo>>() {
        });
    }

    @Deprecated
    public static BaseData<BaseId> createOrg(CreateOrgParam createOrgParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.postRequest(ORG_URL, token, createOrgParam);
        return new BaseData<>(JSONObject.parseObject(baseHttpVO.getDataJson().toString(), BaseId.class));
    }

    @Deprecated
    public static void editOrg(EditOrgParam editOrgParam, String token) {
        HttpClientRequestUtils.putRequest(ORG_URL, token, editOrgParam);
    }

    @Deprecated
    public static void deleteOrg(String id, String token) {
        HttpClientRequestUtils.deleteRequest(ORG_URL, token, new BaseId(id));
    }

    @Deprecated
    public static BaseData<OrgInfo> getOrgById(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(ORG_URL, token, new BaseId(id));
        return new BaseData<>(JSONObject.parseObject(baseHttpVO.getDataJson().toString(), OrgInfo.class));
    }

    @Deprecated
    public static BaseList<OrgTree> getOrgTree(String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GET_ORG_TREE_URL, token, null);
        return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<OrgTree>>() {
        });
    }

    @Deprecated
    public static BaseList<OrgBaseInfo> getOrgListByOrgPath(OrgPathParam orgPathParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GET_ORG_TREE_BY_PATH_URL, token, orgPathParam);
        return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<OrgBaseInfo>>() {
        });
    }

    @Deprecated
    public static void batchCreateOrg(BatchCreateOrgParam batchCreateOrgParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getJsonBaseHttpVO(HttpRequestTypeEnum.POST, BATCH_CREATE_ORG_URL, token, batchCreateOrgParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    @Deprecated
    public static BaseList<OrgInfo> listOrgInfoByOrgCodes(ListOrgInfoByOrgCodesParam orgInfoByOrgCodesParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GET_ORG_LIST_BY_ORG_CODE_URL, token, orgInfoByOrgCodesParam);
        return HttpClientRequestUtils.converterToData(baseHttpVO, new TypeReference<BaseList<OrgInfo>>() {
        });
    }

}