package im.qingtui.qbee.open.platfrom.portal.model.param.org;

import java.io.Serializable;
import java.util.Map;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 创建组织机构基础请求参数
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class CreateOrgBaseParam implements Serializable {

    /**
     * 组织机构名称
     */
    String name;
    /**
     * 组织机构编码
     */
    String code;
    /**
     * 组织机构描述
     */
    String desc;
    /**
     * 父节点组织机构id
     */
    String parentOrgId;
    /**
     * 组织类型ID
     */
    String orgCategoryId;
    /**
     * 主负责人员工ID
     */
    String masterEmployeeId;

    /**
     * 扩展属性
     */
    Map<String, Object> attributeMap;
}