/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.qbee.open.platfrom.portal.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.model.enums.HttpRequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.param.base.BaseCodeParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseData;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseId;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseResult;
import im.qingtui.qbee.open.platfrom.portal.common.constants.UrlConstants;
import im.qingtui.qbee.open.platfrom.portal.model.param.dimension.CreateDimensionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.dimension.EditDimensionParam;
import im.qingtui.qbee.open.platfrom.portal.model.vo.dimension.DimensionInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.dimension.DimensionTree;
import java.io.Serializable;

public class DimensionService {
    public static BaseList<DimensionInfo> getDimensionList() {
        return DimensionService.getDimensionList(TokenUtils.getToken());
    }

    public static BaseList<DimensionInfo> getDimensionList(String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.GET, (String)UrlConstants.GET_DIMENSION_LIST_URL, (String)token);
        if (0 == baseHttpVO.getCode()) {
            BaseList dimensionListVO = (BaseList)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), (TypeReference)new TypeReference<BaseList<DimensionInfo>>(){}, (Feature[])new Feature[0]);
            return dimensionListVO;
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static BaseData<BaseId> createDimension(CreateDimensionParam createDimensionParam) {
        return DimensionService.createDimension(createDimensionParam, TokenUtils.getToken());
    }

    public static BaseData<BaseId> createDimension(CreateDimensionParam createDimensionParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.POST, (String)UrlConstants.CREAT_DIMENSION_URL, (String)token, (Object)createDimensionParam);
        if (0 == baseHttpVO.getCode()) {
            return new BaseData((Serializable)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), BaseId.class));
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static void editDimension(EditDimensionParam editDimensionParam) {
        DimensionService.editDimension(editDimensionParam, TokenUtils.getToken());
    }

    public static void editDimension(EditDimensionParam editDimensionParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.PUT, (String)UrlConstants.EDIT_DIMENSION_URL, (String)token, (Object)editDimensionParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    public static void deleteDimension(String id) {
        DimensionService.deleteDimension(id, TokenUtils.getToken());
    }

    public static void deleteDimension(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.DELETE, (String)UrlConstants.DELETE_DIMENSION_URL, (String)token, (Object)new BaseId(id));
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    public static BaseData<DimensionInfo> getDimensionInfoById(String id) {
        return DimensionService.getDimensionInfoById(id, TokenUtils.getToken());
    }

    public static BaseData<DimensionInfo> getDimensionInfoById(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.GET, (String)UrlConstants.GET_DIMENSION_BY_ID_URL, (String)token, (Object)new BaseId(id));
        if (0 == baseHttpVO.getCode()) {
            return new BaseData((Serializable)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), DimensionInfo.class));
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static BaseData<DimensionInfo> getDimensionInfoByCode(String code) {
        return DimensionService.getDimensionInfoByCode(code, TokenUtils.getToken());
    }

    public static BaseData<DimensionInfo> getDimensionInfoByCode(String code, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.GET, (String)UrlConstants.GET_DIMENSION_BY_CODE_URL, (String)token, (Object)new BaseCodeParam(code));
        if (0 == baseHttpVO.getCode()) {
            return new BaseData((Serializable)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), DimensionInfo.class));
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static BaseList<DimensionTree> getDimensionTree(String id) {
        return DimensionService.getDimensionTree(id, TokenUtils.getToken());
    }

    public static BaseList<DimensionTree> getDimensionTree(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.GET, (String)UrlConstants.GET_DIMENSION_TREE_BY_ID_URL, (String)token, (Object)new BaseId(id));
        if (0 == baseHttpVO.getCode()) {
            return (BaseList)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), (TypeReference)new TypeReference<BaseList<DimensionTree>>(){}, (Feature[])new Feature[0]);
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }
}

