package im.qingtui.qbee.open.platfrom.portal.model.vo.org;

import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.FieldDefaults;

/**
 * 组织机构信息
 *
 * @author shizhen
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class OrgInfo extends OrgBaseInfo implements Serializable {

    /**
     * 是够为叶子节点（false-不是叶子节点，下级还有组织机构。true-是叶子节点，下级没有组织机构）
     */
    Boolean leaf;

    @Override
    public String toString() {
        return "OrgInfo{" +
            "leaf=" + leaf +
            ", id='" + super.getId() + '\'' +
            ", name='" + super.getName() + '\'' +
            ", code='" + super.getCode() + '\'' +
            '}';
    }
}