package im.qingtui.qbee.open.platfrom.portal.model.vo.employee;

import java.io.Serializable;
import java.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 员工权限返回信息
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class EmployeeAuthInfo implements Serializable {

    /**
     * 授权页面功能节点数据id
     */
    String id;
    /**
     * 授权页面功能授权节点的id（此id是配置时用户根据需求配置某个页面功能的id）
     */
    String authId;
    /**
     * 节点控制元素的选择器路径（如：.class1.class2.class3{display:none}）
     */
    String path;
    /**
     * 需要控制的接口列表（页面某个功能操作后调用的后端接口列表，比如：“user/info”）
     */
    String restfulApi;
    /**
     * 数据域授权的数据域列表
     */
    List<AuthData> authDatas;
}