package im.qingtui.qbee.open.platfrom.portal.model.param.position;

import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 创建岗位请求参数
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class CreatePositionParam implements Serializable {

    /**
     * 岗位名称
     */
    String name;
    /**
     * 岗位编码
     */
    String code;
    /**
     * 岗位描述
     */
    String desc;
    /**
     * 岗位所属组织机构id
     */
    String orgId;
    /**
     * 岗位所属职务id
     */
    String dutyId;
    /**
     * 序列ID
     */
    String sequenceId;
    /**
     * 岗级最小值
     */
    String positionLevelIdMin;
    /**
     * 岗级最大值
     */
    String positionLevelIdMax;
}