package im.qingtui.qbee.open.platfrom.msg.service;

import static im.qingtui.qbee.open.platfrom.msg.common.constants.UrlConstants.GET_ALARM_CONFIG_LIST_URL;
import static im.qingtui.qbee.open.platfrom.msg.common.constants.UrlConstants.GET_ALARM_LEVEL_LIST_URL;
import static im.qingtui.qbee.open.platfrom.msg.common.constants.UrlConstants.GET_COMMON_MSG_TYPE_LIST_URL;
import static im.qingtui.qbee.open.platfrom.msg.common.constants.UrlConstants.MESSAGE_READ;
import static im.qingtui.qbee.open.platfrom.msg.common.constants.UrlConstants.SEND_ALARM_MSG_URL;
import static im.qingtui.qbee.open.platfrom.msg.common.constants.UrlConstants.SEND_COMMON_MSG_URL;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.UrlUtil;
import im.qingtui.qbee.open.platfrom.base.model.enums.HttpRequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.param.base.BaseKeywordParam;
import im.qingtui.qbee.open.platfrom.base.model.param.base.IdParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseResult;
import im.qingtui.qbee.open.platfrom.msg.common.constants.UrlConstants;
import im.qingtui.qbee.open.platfrom.msg.model.param.msg.SendAlarmMsgParam;
import im.qingtui.qbee.open.platfrom.msg.model.param.msg.SendCommonMsgParam;
import im.qingtui.qbee.open.platfrom.msg.model.vo.msg.AlarmConfigInfo;

/**
 * 消息相关接口
 *
 * @author shizhen
 */
public class MsgService {

    /**
     * 获取开放平台服务所属团队下的报警消息等级信息列表（不带token,取配置文件的服务号信息获取token）
     *
     * @return 开放平台服务所属团队下的报警消息等级信息列表
     */
    public static BaseList<BaseInfo> getAlarmLevelList() {
        return getAlarmLevelList(TokenUtils.getToken());
    }

    /**
     * 获取开放平台服务所属团队下的报警消息等级信息列表
     *
     * @param token 开放平台服务token
     * @return 开放平台服务所属团队下的报警消息等级信息列表
     */
    public static BaseList<BaseInfo> getAlarmLevelList(String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, UrlUtil.getFullPath(GET_ALARM_LEVEL_LIST_URL), token);
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<BaseInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 获取开放平台服务所属团队下的报警配置信息列表（不带token,取配置文件的服务号信息获取token）
     *
     * @return 开放平台服务所属团队下的报警配置信息列表
     */
    public static BaseList<AlarmConfigInfo> getAlarmConfigList() {
        return getAlarmConfigList(TokenUtils.getToken());
    }

    /**
     * 获取开放平台服务所属团队下的报警配置信息列表
     *
     * @param token 开放平台token
     * @return 开放平台服务所属团队下的报警配置信息列表
     */
    public static BaseList<AlarmConfigInfo> getAlarmConfigList(String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, UrlUtil.getFullPath(GET_ALARM_CONFIG_LIST_URL), token);
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<AlarmConfigInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 发送通用消息（不带token,取配置文件的服务号信息获取token）
     *
     * @param sendCommonMsgParam 发送通用消息参数
     */
    public static void sendCommonMsg(SendCommonMsgParam sendCommonMsgParam) {
        sendCommonMsg(sendCommonMsgParam, TokenUtils.getToken());
    }

    /**
     * 发送通用消息
     *
     * @param sendCommonMsgParam 发送通用消息参数
     * @param token              开放平台token
     */
    public static void sendCommonMsg(SendCommonMsgParam sendCommonMsgParam, String token) {
        HttpClientRequestUtils.postRequestJson(UrlUtil.getOpenUrl(SEND_COMMON_MSG_URL), token, sendCommonMsgParam);
    }

    /**
     * 获取通用消息分类信息列表（不带token,取配置文件的服务号信息获取token）
     *
     * @param keyword 搜索关键字（分类名称）
     * @return 通用消息分类信息列表
     */
    public static BaseList<BaseInfo> getMsgCommonTypeList(String keyword) {
        return getMsgCommonTypeList(keyword, TokenUtils.getToken());
    }

    /**
     * 获取通用消息分类信息列表
     *
     * @param keyword 搜索关键字（分类名称）
     * @param token   开放平台token
     * @return 通用消息分类信息列表
     */
    public static BaseList<BaseInfo> getMsgCommonTypeList(String keyword, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils
            .getBaseHttpVO(HttpRequestTypeEnum.GET, UrlUtil.getFullPath(GET_COMMON_MSG_TYPE_LIST_URL), token, new BaseKeywordParam(keyword));
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<BaseInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 发送报警消息（不带token,取配置文件的服务号信息获取token）
     *
     * @param sendAlarmMsgParam 发送报警消息参数
     */
    public static void sendAlarmMsg(SendAlarmMsgParam sendAlarmMsgParam) {
        sendAlarmMsg(sendAlarmMsgParam, TokenUtils.getToken());
    }

    /**
     * 发送报警消息
     *
     * @param sendAlarmMsgParam 发送报警消息参数
     * @param token             开放平台token
     */
    public static void sendAlarmMsg(SendAlarmMsgParam sendAlarmMsgParam, String token) {
        HttpClientRequestUtils.postRequestJson(UrlUtil.getOpenUrl(SEND_ALARM_MSG_URL), token, sendAlarmMsgParam);
    }

    /**
     * 消息已读
     *
     * @param param IdParam
     */
    public static void readMessage(IdParam param) {
        HttpClientRequestUtils.putRequest(UrlUtil.getOpenUrl(MESSAGE_READ), TokenUtils.getToken(), param);
    }

}