package im.qingtui.qbee.open.platfrom.msg.model.param.msg;

import java.io.Serializable;
import java.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 发送普通消息请求参数
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class SendCommonMsgParam implements Serializable {

    /**
     * 消息接收者id列表
     */
    List<String> receiverIdList;
    /**
     * 消息标题
     */
    String title;
    /**
     * 消息内容
     */
    String content;
    /**
     * 消息的链接
     */
    String link;
    /**
     * 消息发送者id
     */
    String sender;
    /**
     * 消息消息类型id（不填，则在全部分类下面）
     */
    String typeId;
    /**
     * 消息接收者类型（1:员工，2:组织机构）
     */
    Integer receiverType;
    /**
     * 回调地址
     */
    String callbackAddress;
}