package im.qingtui.qbee.open.platfrom.msg.model.vo.msg;

import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.FieldDefaults;

/**
 * 报警消息配置返回信息
 *
 * @author shizhen
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
@ToString(callSuper = true)
public class AlarmConfigInfo extends BaseInfo implements Serializable {

    /**
     * 报警配置标题
     */
    String title;
    /**
     * 报警配置描述
     */
    String desc;
    /**
     * 报警配置所属报警分类id
     */
    String typeId;
    /**
     * 报警配置所属报警分组id
     */
    String groupId;

}