package im.qingtui.qbee.open.platfrom.msg.model.param.msg;

import java.io.Serializable;
import java.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 发送报警消息请求参数
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class SendAlarmMsgParam implements Serializable {

    /**
     * 报警消息标题
     */
    String title;
    /**
     * 报警消息内容
     */
    String content;
    /**
     * 报警消息配置id
     */
    String alarmConfigId;
    /**
     * 报警等级id
     */
    String levelId;
    /**
     * 消息的来源标识，用户可在报警中心设置同一来源的消息为“重点关注”或者“暂不关注”，不传或者传空，默认信息来源为当前服务
     */
    String resourceId;
    /**
     * 消息变量，用于替换消息中的变量，注意同一key不能对应多个值
     */
    List<Variable> variableList;
    /**
     * 附件列表
     */
    List<Attachment> attachmentList;
}