package im.qingtui.qbee.open.platfrom.inside.service;

import static im.qingtui.qbee.open.platfrom.inside.model.constant.UrlConstant.PARTY_PAGE_URL;

import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.UrlUtil;
import im.qingtui.qbee.open.platfrom.base.model.param.base.BasePageParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BasePage;
import im.qingtui.qbee.open.platfrom.inside.model.vo.PartyVO;
import lombok.val;

/**
 * <p> title:
 * <p> time: 2021/5/7 10:24 上午
 * <p> Copyright © 2010-2021 CISDI Info. All Rights Reserved.
 *
 * @author 阳君
 * @version 1.0.0
 */
public class PartyService {

    /**
     * 分页获取团队信息
     *
     * @param param 分页参数
     * @param token 青峰token
     * @return BasePage
     */
    public static BasePage<PartyVO> page(BasePageParam param, String token) {
        val baseHttpVO = HttpClientRequestUtils.getRequest(UrlUtil.getApiUrl(PARTY_PAGE_URL), token, param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BasePage<PartyVO>>() {
        });
    }

}
