package im.qingtui.qbee.open.platfrom.drive.model.vo.file;

import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 开放平台文件信息
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class FileVO implements Serializable {

    /**
     * 文件id
     */
    String fileId;
    /**
     * 文件名称
     */
    String fileName;
    /**
     * 文件大小
     */
    Long fileSize;
    /**
     * 备注
     */
    String comment;
    /**
     * 文件类型
     */
    String contentType;
    /**
     * 文件更新时间
     */
    Long gmtModified;
    /**
     * 文件id/空间id
     */
    String folderId;
}