/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.qbee.open.platfrom.base.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.util.IOUtils;
import im.qingtui.qbee.open.platfrom.base.common.exception.BaseRunTimeException;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.common.utils.ConfigUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpDeleteEntity;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpGetEntity;
import im.qingtui.qbee.open.platfrom.base.model.dto.exception.CodeMsgDTO;
import im.qingtui.qbee.open.platfrom.base.model.dto.http.CustomerHttpClient;
import im.qingtui.qbee.open.platfrom.base.model.dto.http.HttpResponseBodyDTO;
import im.qingtui.qbee.open.platfrom.base.model.enums.HttpRequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.enums.QBeeResponseDataEnum;
import im.qingtui.qbee.open.platfrom.base.model.enums.RequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.param.http.HeaderParam;
import im.qingtui.qbee.open.platfrom.base.model.param.http.RequestHeader;
import im.qingtui.qbee.open.platfrom.base.model.param.http.RequestParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRequestUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestUtils.class);

    private static String post(String url, RequestParam ... params) {
        String body;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClientRequestUtils.getVerifyHttpClient();
            HttpPost post = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(60000).setSocketTimeout(60000).setConnectTimeout(60000).build();
            post.setConfig(requestConfig);
            UrlEncodedFormEntity urlEntity = HttpClientRequestUtils.createParam(params);
            Header[] requestHeaders = HttpClientRequestUtils.createHeader(true, params);
            post.setHeaders(requestHeaders);
            post.setEntity((HttpEntity)urlEntity);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)post);
            body = HttpClientRequestUtils.readFromHttpResponse(httpResponse);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u8f7b\u63a8\u534f\u540c\u5931\u8d25", (Throwable)e);
            throw new IllegalRequestException(e.getMessage());
        }
        finally {
            HttpClientRequestUtils.closeHttpClient(httpClient);
        }
        return body;
    }

    private static String get(String url, RequestParam ... params) {
        String body;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClientRequestUtils.getVerifyHttpClient();
            UrlEncodedFormEntity urlEntity = HttpClientRequestUtils.createGetParam(params);
            String getParams = "";
            if (urlEntity != null) {
                getParams = EntityUtils.toString((HttpEntity)urlEntity);
            }
            url = url + "?" + getParams;
            HttpGet get = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(60000).setSocketTimeout(60000).setConnectTimeout(60000).build();
            get.setConfig(requestConfig);
            Header[] requestHeaders = HttpClientRequestUtils.createHeader(true, params);
            get.setHeaders(requestHeaders);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)get);
            body = HttpClientRequestUtils.readFromHttpResponse(httpResponse);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u8f7b\u63a8\u534f\u540c\u5931\u8d25", (Throwable)e);
            throw new IllegalRequestException(e.getMessage());
        }
        finally {
            HttpClientRequestUtils.closeHttpClient(httpClient);
        }
        return body;
    }

    private static UrlEncodedFormEntity createGetParam(RequestParam ... params) {
        ArrayList<RequestParam> bodyParams = new ArrayList<RequestParam>();
        if (params != null && params.length > 0) {
            for (RequestParam param : params) {
                if (RequestTypeEnum.BODY != param.getRequestType()) continue;
                bodyParams.add(param);
            }
        }
        UrlEncodedFormEntity urlEntity = null;
        if (bodyParams.size() > 0) {
            ArrayList list = new ArrayList();
            bodyParams.forEach(bodyParam -> list.add(new BasicNameValuePair(bodyParam.getName(), bodyParam.getValue())));
            try {
                urlEntity = new UrlEncodedFormEntity(list, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u8bf7\u6c42\u8f7b\u63a8\u534f\u540c\u5931\u8d25", (Throwable)e);
                throw new IllegalRequestException(e.getMessage());
            }
        }
        return urlEntity;
    }

    private static String put(String url, RequestParam ... params) {
        String body;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClientRequestUtils.getVerifyHttpClient();
            HttpPut put = new HttpPut(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(60000).setSocketTimeout(60000).setConnectTimeout(60000).build();
            put.setConfig(requestConfig);
            UrlEncodedFormEntity urlEntity = HttpClientRequestUtils.createParam(params);
            urlEntity.setContentEncoding("UTF-8");
            urlEntity.setContentType("application/json");
            Header[] requestHeaders = HttpClientRequestUtils.createHeader(true, params);
            put.setHeaders(requestHeaders);
            put.setEntity((HttpEntity)urlEntity);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)put);
            body = HttpClientRequestUtils.readFromHttpResponse(httpResponse);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u8f7b\u63a8\u534f\u540c\u5931\u8d25", (Throwable)e);
            throw new IllegalRequestException(e.getMessage());
        }
        finally {
            HttpClientRequestUtils.closeHttpClient(httpClient);
        }
        return body;
    }

    private static String delete(String url, RequestParam ... params) {
        String body;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClientRequestUtils.getVerifyHttpClient();
            UrlEncodedFormEntity urlEntity = HttpClientRequestUtils.createParam(params);
            String getParams = "";
            if (urlEntity != null) {
                getParams = EntityUtils.toString((HttpEntity)urlEntity);
            }
            url = url + "?" + getParams;
            HttpDelete delete = new HttpDelete(url);
            Header[] requestHeaders = HttpClientRequestUtils.createHeader(true, params);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(60000).setSocketTimeout(60000).setConnectTimeout(60000).build();
            delete.setConfig(requestConfig);
            delete.setHeaders(requestHeaders);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)delete);
            body = HttpClientRequestUtils.readFromHttpResponse(httpResponse);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u8f7b\u63a8\u534f\u540c\u5931\u8d25", (Throwable)e);
            throw new IllegalRequestException(e.getMessage());
        }
        finally {
            HttpClientRequestUtils.closeHttpClient(httpClient);
        }
        return body;
    }

    private static String readFromHttpResponse(CloseableHttpResponse httpResponse) throws IOException {
        String body = "";
        try {
            HttpEntity entity = httpResponse.getEntity();
            if (null != entity) {
                body = HttpClientRequestUtils.inputStream2String(entity.getContent());
            }
        }
        finally {
            httpResponse.close();
        }
        return body;
    }

    private static UrlEncodedFormEntity createParam(RequestParam ... params) {
        ArrayList<RequestParam> bodyParams = new ArrayList<RequestParam>();
        if (params != null && params.length > 0) {
            for (RequestParam requestParam : params) {
                if (!RequestTypeEnum.BODY.equals((Object)requestParam.getRequestType())) continue;
                bodyParams.add(requestParam);
            }
        }
        UrlEncodedFormEntity urlEntity = null;
        if (bodyParams.size() > 0) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (RequestParam bodyParam : bodyParams) {
                list.add(new BasicNameValuePair(bodyParam.getName(), bodyParam.getValue()));
            }
            try {
                urlEntity = new UrlEncodedFormEntity(list, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalRequestException(e.getMessage());
            }
        }
        return urlEntity;
    }

    private static RequestHeader[] createHeader(boolean setContent, RequestParam ... params) {
        ArrayList<RequestParam> bodyParams = new ArrayList<RequestParam>();
        if (params != null && params.length > 0) {
            for (RequestParam requestParam : params) {
                if (!RequestTypeEnum.HEADER.equals((Object)requestParam.getRequestType())) continue;
                bodyParams.add(requestParam);
            }
        }
        ArrayList<RequestHeader> requestHeaderList = new ArrayList<RequestHeader>();
        if (setContent) {
            RequestParam requestParam = new RequestParam();
            requestParam.setName("content-type");
            requestParam.setValue("application/x-www-form-urlencoded");
            bodyParams.add(requestParam);
        }
        for (RequestParam bodyParam : bodyParams) {
            requestHeaderList.add(new RequestHeader(bodyParam.getName(), bodyParam.getValue()));
        }
        RequestHeader[] requestHeaderArray = new RequestHeader[requestHeaderList.size()];
        requestHeaderList.toArray(requestHeaderArray);
        return requestHeaderArray;
    }

    private static void closeHttpClient(CloseableHttpClient client) {
        try {
            if (client != null) {
                client.close();
            }
        }
        catch (IOException e) {
            log.error("\u5173\u95ed\u6d41\u5931\u8d25", (Throwable)e);
        }
    }

    private static String inputStream2String(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((i = is.read()) != -1) {
            byteArrayOutputStream.write(i);
        }
        return byteArrayOutputStream.toString("UTF-8");
    }

    public static HttpResponseBodyDTO postResponse(String url, RequestParam ... params) {
        CloseableHttpClient httpClient = CustomerHttpClient.getCloseableHttpClient();
        try {
            HttpPost post = new HttpPost(url);
            UrlEncodedFormEntity urlEntity = HttpClientRequestUtils.createParam(params);
            Header[] requestHeaders = HttpClientRequestUtils.createHeader(true, params);
            post.setHeaders(requestHeaders);
            post.setEntity((HttpEntity)urlEntity);
            HttpResponseBodyDTO httpResponseBodyDTO = HttpClientRequestUtils.getHttpResponseBodyDTO(CustomerHttpClient.getCloseableHttpClient().execute((HttpUriRequest)post));
            return httpResponseBodyDTO;
        }
        catch (BaseRunTimeException baseRunTimeException) {
            log.error("\u8bf7\u6c42\u8f7b\u63a8\u534f\u540c\u5931\u8d25", (Throwable)baseRunTimeException);
            throw baseRunTimeException;
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u8f7b\u63a8\u534f\u540c\u5931\u8d25", (Throwable)e);
            throw new IllegalRequestException(e.getMessage());
        }
        finally {
            HttpClientRequestUtils.closeHttpClient(httpClient);
        }
    }

    public static HttpResponseBodyDTO getResponse(String url, RequestParam ... params) {
        try {
            String getParams;
            UrlEncodedFormEntity urlEntity = HttpClientRequestUtils.createParam(params);
            if (urlEntity != null && (getParams = EntityUtils.toString((HttpEntity)urlEntity)).length() > 0) {
                url = url.contains("?") ? url + "&" + getParams : url + "?" + getParams;
            }
            HttpGet get = new HttpGet(url);
            Header[] requestHeaders = HttpClientRequestUtils.createHeader(true, params);
            get.setHeaders(requestHeaders);
            HttpResponseBodyDTO httpResponseBodyDTO = HttpClientRequestUtils.getHttpResponseBodyDTO(CustomerHttpClient.getCloseableHttpClient().execute((HttpUriRequest)get));
            return httpResponseBodyDTO;
        }
        catch (BaseRunTimeException baseRunTimeException) {
            log.error("\u8bf7\u6c42\u8f7b\u63a8\u534f\u540c\u5931\u8d25", (Throwable)baseRunTimeException);
            throw baseRunTimeException;
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u8f7b\u63a8\u534f\u540c\u5931\u8d25", (Throwable)e);
            throw new IllegalRequestException(e.getMessage());
        }
        finally {
            HttpClientRequestUtils.closeHttpClient(CustomerHttpClient.getCloseableHttpClient());
        }
    }

    private static HttpResponseBodyDTO getHttpResponseBodyDTO(CloseableHttpResponse response) {
        String body = HttpClientRequestUtils.checkResponse(response);
        Header[] headers = response.getHeaders("Authorization");
        return new HttpResponseBodyDTO(body, headers);
    }

    public static List<RequestParam> getRequestParamList(String token, Object object) {
        ArrayList<RequestParam> requestParamList = new ArrayList<RequestParam>();
        try {
            if (token != null) {
                requestParamList.addAll(ConfigUtils.beanToRequestParam(new HeaderParam(token), RequestTypeEnum.HEADER));
            }
            if (object != null) {
                requestParamList.addAll(ConfigUtils.beanToRequestParam(object, RequestTypeEnum.BODY));
            }
        }
        catch (Exception e) {
            log.error("\u7ec4\u88c5\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new IllegalRequestException(new BaseResult(-1, "\u7cfb\u7edf\u5f02\u5e38"));
        }
        return requestParamList;
    }

    @Deprecated
    public static BaseHttpVO getBaseHttpVO(HttpRequestTypeEnum httpRequestTypeEnum, String url, Object object) {
        return HttpClientRequestUtils.getBaseHttpVO(httpRequestTypeEnum, url, null, object);
    }

    @Deprecated
    public static BaseHttpVO getBaseHttpVO(HttpRequestTypeEnum httpRequestTypeEnum, String url, String token) {
        return HttpClientRequestUtils.getBaseHttpVO(httpRequestTypeEnum, url, token, null);
    }

    public static BaseHttpVO getRequest(String url, String token, Object object) {
        return HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, url, token, object);
    }

    public static BaseHttpVO postRequest(String url, String token, Object object) {
        return HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.POST, url, token, object);
    }

    public static BaseHttpVO putRequest(String url, String token, Object object) {
        return HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.PUT, url, token, object);
    }

    public static BaseHttpVO deleteRequest(String url, String token, Object object) {
        return HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.DELETE, url, token, object);
    }

    public static <T> T convertToData(BaseHttpVO vo, TypeReference<T> type) {
        if (vo.getDataJson() == null || type == null) {
            return null;
        }
        Object data = JSONObject.parseObject((String)vo.getDataJson().toString(), type, (Feature[])new Feature[0]);
        log.debug(data.toString());
        return (T)data;
    }

    public static <T> List<T> convertToList(BaseHttpVO vo, TypeReference<BaseList<T>> type) {
        BaseList<T> data = HttpClientRequestUtils.convertToData(vo, type);
        return BaseList.getData(data);
    }

    @Deprecated
    public static BaseHttpVO getBaseHttpVO(HttpRequestTypeEnum httpRequestTypeEnum, String url, String token, Object object) {
        log.debug(url);
        if (object != null) {
            log.debug(JSONObject.toJSON((Object)object).toString());
        }
        List<RequestParam> requestParamList = HttpClientRequestUtils.getRequestParamList(token, object);
        String info = null;
        if (HttpRequestTypeEnum.GET.equals((Object)httpRequestTypeEnum)) {
            info = HttpClientRequestUtils.get(url, (RequestParam[])requestParamList.stream().toArray(RequestParam[]::new));
        } else if (HttpRequestTypeEnum.POST.equals((Object)httpRequestTypeEnum)) {
            info = HttpClientRequestUtils.post(url, (RequestParam[])requestParamList.stream().toArray(RequestParam[]::new));
        } else if (HttpRequestTypeEnum.PUT.equals((Object)httpRequestTypeEnum)) {
            info = HttpClientRequestUtils.put(url, (RequestParam[])requestParamList.stream().toArray(RequestParam[]::new));
        } else if (HttpRequestTypeEnum.DELETE.equals((Object)httpRequestTypeEnum)) {
            info = HttpClientRequestUtils.delete(url, (RequestParam[])requestParamList.stream().toArray(RequestParam[]::new));
        }
        return HttpClientRequestUtils.converterToVO(info);
    }

    private static BaseHttpVO converterToVO(String json) {
        log.debug(json);
        JSONObject infoJson = JSONObject.parseObject((String)json);
        BaseHttpVO vo = new BaseHttpVO();
        vo.setCode(infoJson.getIntValue("code"));
        vo.setMessage(infoJson.getString("message"));
        if (vo.getCode() != 0 && vo.getCode() != 200) {
            throw new IllegalRequestException(new BaseResult(vo));
        }
        vo.setDataJson(infoJson.getJSONObject("data"));
        return vo;
    }

    private static String checkResponse(CloseableHttpResponse response) {
        String body;
        try {
            body = HttpClientRequestUtils.readFromHttpResponse(response);
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u8fd4\u56de\u503c\u5931\u8d25", (Throwable)e);
            throw new BaseRunTimeException(new CodeMsgDTO(-1L, "\u7cfb\u7edf\u5f02\u5e38"));
        }
        JSONObject infoJson = JSONObject.parseObject((String)body);
        int code = infoJson.getIntValue("code");
        String msg = infoJson.getString("message");
        if (QBeeResponseDataEnum.STATUS_SUCCESS_CODE_0.getCode() != code && QBeeResponseDataEnum.STATUS_SUCCESS_CODE_200.getCode() != code) {
            throw new BaseRunTimeException(new CodeMsgDTO(code, msg));
        }
        return body;
    }

    public static BaseHttpVO postRequestJson(String url, String token, Object object) {
        String json = HttpClientRequestUtils.execute((HttpEntityEnclosingRequestBase)new HttpPost(url), token, object);
        return HttpClientRequestUtils.converterToVO(json);
    }

    public static BaseHttpVO deleteRequestJson(String url, String token, Object object) {
        String json = HttpClientRequestUtils.execute(new HttpDeleteEntity(url), token, object);
        return HttpClientRequestUtils.converterToVO(json);
    }

    public static BaseHttpVO putRequestJson(String url, String token, Object object) {
        String json = HttpClientRequestUtils.execute((HttpEntityEnclosingRequestBase)new HttpPut(url), token, object);
        return HttpClientRequestUtils.converterToVO(json);
    }

    public static BaseHttpVO getRequestJson(String url, String token, Object object) {
        String json = HttpClientRequestUtils.execute(new HttpGetEntity(url), token, object);
        return HttpClientRequestUtils.converterToVO(json);
    }

    private static String execute(HttpEntityEnclosingRequestBase request, String token, Object object) {
        log.debug(request.getURI().toString());
        CloseableHttpClient httpClient = CustomerHttpClient.getCloseableHttpClient();
        try {
            request.setHeaders((Header[])HttpClientRequestUtils.createJsonHeader(token));
            request.setEntity((HttpEntity)HttpClientRequestUtils.createJsonBody(object));
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
            String string = HttpClientRequestUtils.readFromHttpResponse(httpResponse);
            return string;
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            throw new IllegalRequestException(e.getMessage());
        }
        finally {
            HttpClientRequestUtils.closeHttpClient(httpClient);
        }
    }

    private static RequestHeader[] createJsonHeader(String token) {
        List<RequestHeader> requestHeaderList = Collections.singletonList(new RequestHeader("Authorization", token));
        RequestHeader[] requestHeader = new RequestHeader[requestHeaderList.size()];
        requestHeaderList.toArray(requestHeader);
        return requestHeader;
    }

    private static StringEntity createJsonBody(Object object) {
        String jsonParams = JSONObject.toJSONString((Object)object);
        log.debug(jsonParams);
        StringEntity urlEntity = new StringEntity(jsonParams, IOUtils.UTF8);
        urlEntity.setContentType("application/json");
        return urlEntity;
    }

    private static SSLContext createIgnoreVerifySSL() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = SSLContext.getInstance("SSLv3");
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        return sc;
    }

    private static CloseableHttpClient getVerifyHttpClient() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslcontext = HttpClientRequestUtils.createIgnoreVerifySSL();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }
}

