/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.qbee.open.platfrom.base.common.utils;

import java.util.Calendar;
import java.util.TimeZone;

public class DateUtils {
    public static final Long TWELVE_HOURS_MILLIS = 43200000L;

    public static Long getDailyStartTime(Long timeStamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        calendar.setTimeInMillis(timeStamp);
        calendar.set(11, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static boolean betweenTimeHms(long gmtTime, long gmtStart, long gmtEnd) {
        long timeValue = gmtTime - DateUtils.getDailyStartTime(gmtTime);
        long startTimeValue = gmtStart - DateUtils.getDailyStartTime(gmtStart);
        long endTimeValue = startTimeValue + gmtEnd - gmtStart;
        return startTimeValue <= timeValue && timeValue <= endTimeValue;
    }

    public static boolean betweenTimeHms2(long gmtTime, long gmtStart, long gmtEnd) {
        long timeValue = gmtTime - DateUtils.getDailyStartTime(gmtTime) + 2L * TWELVE_HOURS_MILLIS;
        long startTimeValue = gmtStart - DateUtils.getDailyStartTime(gmtStart);
        long endTimeValue = startTimeValue + gmtEnd - gmtStart;
        return startTimeValue <= timeValue && timeValue <= endTimeValue;
    }

    public static Long distanceStartTime(long gmtTime) {
        return gmtTime - DateUtils.getDailyStartTime(gmtTime);
    }
}

