/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.qbee.open.platfrom.base.common.utils;

import im.qingtui.qbee.open.platfrom.base.model.enums.RequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.param.http.RequestParam;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtils.class);
    private static final Properties props = new Properties();

    public static void setValue(String key, String value) {
        props.setProperty(key, value);
    }

    public static String getValue(String key) {
        return props.getProperty(key);
    }

    public static <T> List<RequestParam> beanToRequestParam(T bean, RequestTypeEnum requestTypeEnum) throws IllegalAccessException {
        ArrayList<RequestParam> requestParams = new ArrayList<RequestParam>();
        if (bean != null) {
            Map<String, Object> beanMap = ConfigUtils.getObjectToMap(bean);
            for (String key : beanMap.keySet()) {
                Object value = beanMap.get(key);
                if (value instanceof List) {
                    ((List)value).forEach(item -> {
                        RequestParam param = new RequestParam(String.valueOf(key), String.valueOf(item), requestTypeEnum);
                        requestParams.add(param);
                    });
                    continue;
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    map.keySet().forEach(item -> {
                        RequestParam param = new RequestParam(key + "[" + item + "]", String.valueOf(map.get(item)), requestTypeEnum);
                        requestParams.add(param);
                    });
                    continue;
                }
                RequestParam param = new RequestParam(String.valueOf(key), String.valueOf(value), requestTypeEnum);
                requestParams.add(param);
            }
        }
        return requestParams;
    }

    public static Map<String, Object> getObjectToMap(Object obj) throws IllegalAccessException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Class<?> clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        while (fields.length != 0) {
            for (Field field : fields) {
                field.setAccessible(true);
                Object value = field.get(obj);
                if (value == null) continue;
                map.put(field.getName(), value);
            }
            clazz = clazz.getSuperclass();
            fields = clazz.getDeclaredFields();
        }
        return map;
    }

    static {
        try {
            props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("qbee.properties"));
        }
        catch (IOException e) {
            log.error("\u66f4\u65b0\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }
}

