/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.qbee.open.platfrom.base.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CollectionUtils {
    public static Boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static Boolean isNotEmpty(Collection<?> coll) {
        return CollectionUtils.isEmpty(coll) == false;
    }

    public static Boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static Boolean isNotEmpty(Map<?, ?> map) {
        return CollectionUtils.isEmpty(map) == false;
    }

    public static <E> E get(List<E> list, int index) {
        return CollectionUtils.isEmpty(list) != false ? null : (E)list.get(index);
    }

    public static <T, R> List<R> toList(Collection<T> coll, Function<? super T, ? extends R> mapper) {
        if (CollectionUtils.isEmpty(coll).booleanValue()) {
            return new ArrayList();
        }
        return coll.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T, R> List<R> toDistinctList(Collection<T> coll, Function<? super T, ? extends R> mapper) {
        if (CollectionUtils.isEmpty(coll).booleanValue()) {
            return new ArrayList();
        }
        return coll.stream().map(mapper).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public static <T, K> Map<K, T> toMap(Collection<T> coll, Function<? super T, ? extends K> keyMapper) {
        return CollectionUtils.toMap(coll, keyMapper, t -> t);
    }

    public static <T, K, U> Map<K, U> toMap(Collection<T> coll, Function<? super T, ? extends K> keyMapper, Function<T, U> valueMapper) {
        return CollectionUtils.toMap(coll, keyMapper, valueMapper, (a, b) -> b);
    }

    public static <T, K, U> Map<K, U> toMap(Collection<T> coll, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        if (CollectionUtils.isEmpty(coll).booleanValue()) {
            return new HashMap();
        }
        return coll.stream().collect(Collectors.toMap(keyMapper, valueMapper, mergeFunction));
    }
}

