/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.qbee.open.platfrom.base.service;

import com.alibaba.fastjson.JSONObject;
import im.qingtui.qbee.open.platfrom.base.common.constants.UrlConstants;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.common.utils.ConfigUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.model.enums.HttpRequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.param.token.AutoRefreshParam;
import im.qingtui.qbee.open.platfrom.base.model.param.token.ForceRefreshParam;
import im.qingtui.qbee.open.platfrom.base.model.param.token.GetTokenParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseResult;
import im.qingtui.qbee.open.platfrom.base.model.vo.token.RefreshToken;
import im.qingtui.qbee.open.platfrom.base.model.vo.token.Token;

public class TokenService {
    public static Token getToken(String serviceId, String serviceSecret) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, UrlConstants.GET_TOKEN_URL, new GetTokenParam(serviceId, serviceSecret));
        if (0 == baseHttpVO.getCode()) {
            Token token = (Token)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), Token.class);
            token.setToken("Bearer " + token.getToken());
            return token;
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static Token getToken() {
        return TokenService.getToken(ConfigUtils.getValue("service.id"), ConfigUtils.getValue("service.secret"));
    }

    public static RefreshToken autoRefreshToken(String refreshToken) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, UrlConstants.REFRESH_TOKEN_URL, new AutoRefreshParam(refreshToken));
        if (0 == baseHttpVO.getCode()) {
            RefreshToken refreshTokenVO = (RefreshToken)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), RefreshToken.class);
            refreshTokenVO.setToken("Bearer " + refreshTokenVO.getToken());
            return refreshTokenVO;
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static void forceRefreshToken(String refreshToken) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.POST, UrlConstants.FORCE_REFRESH_TOKEN_URL, new ForceRefreshParam(refreshToken));
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }
}

