package im.qingtui.qbee.open.platfrom.auth.service;

import static im.qingtui.qbee.open.platfrom.auth.common.constants.UrlConstants.ROLE_TREE_URL;
import static im.qingtui.qbee.open.platfrom.auth.common.constants.UrlConstants.ROLE_URL;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.auth.model.param.role.CreateRoleParam;
import im.qingtui.qbee.open.platfrom.auth.model.param.role.EditRoleParam;
import im.qingtui.qbee.open.platfrom.auth.model.vo.role.RoleInfo;
import im.qingtui.qbee.open.platfrom.auth.model.vo.role.RoleTree;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.UrlUtil;
import im.qingtui.qbee.open.platfrom.base.model.param.base.BaseKeywordParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseData;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseId;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;

/**
 * 角色相关接口
 *
 * @author shizhen
 */
public class RoleService {

    /**
     * 新增角色
     *
     * @param createRoleParam 创建角色参数
     * @return 创建的角色id
     */
    public static BaseData<BaseId> createRole(CreateRoleParam createRoleParam) {
        return creatRole(createRoleParam, TokenUtils.getToken());
    }

    /**
     * 删除角色
     *
     * @param id 角色id
     */
    public static void deleteRole(String id) {
        deleteRole(id, TokenUtils.getToken());
    }

    /**
     * 修改角色
     *
     * @param editRoleParam 编辑角色参数
     */
    public static void editRole(EditRoleParam editRoleParam) {
        editRole(editRoleParam, TokenUtils.getToken());
    }

    /**
     * 通过角色id获取角色信息
     *
     * @param id 角色id
     * @return 查询的角色信息
     */
    public static BaseData<RoleInfo> getRoleList(String id) {
        return getRoleList(id, TokenUtils.getToken());
    }

    /**
     * 通过搜索获取角色树
     *
     * @param keyword 搜索关键字（角色名称）
     * @return 开放平台服务所属团队下的角色树
     */
    public static BaseList<RoleTree> getRoleTree(String keyword) {
        return getRoleTree(keyword, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseList<RoleTree> getRoleTree(String keyword, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(UrlUtil.getOpenUrl(ROLE_TREE_URL), token, new BaseKeywordParam(keyword));
        return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<RoleTree>>() {
        });
    }

    @Deprecated
    public static BaseData<BaseId> creatRole(CreateRoleParam createRoleParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.postRequest(UrlUtil.getOpenUrl(ROLE_URL), token, createRoleParam);
        return new BaseData<>(JSONObject.parseObject(baseHttpVO.getDataJson().toString(), BaseId.class));
    }

    @Deprecated
    public static void editRole(EditRoleParam editRoleParam, String token) {
        HttpClientRequestUtils.putRequest(UrlUtil.getOpenUrl(ROLE_URL), token, editRoleParam);
    }

    @Deprecated
    public static void deleteRole(String id, String token) {
        HttpClientRequestUtils.deleteRequest(UrlUtil.getOpenUrl(ROLE_URL), token, new BaseId(id));

    }

    @Deprecated
    public static BaseData<RoleInfo> getRoleList(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(UrlUtil.getOpenUrl(ROLE_URL), token, new BaseId(id));
        return new BaseData<>(JSONObject.parseObject(baseHttpVO.getDataJson().toString(), RoleInfo.class));
    }

}