package im.qingtui.qbee.open.platfrom.auth.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.auth.model.param.menu.*;
import im.qingtui.qbee.open.platfrom.base.common.utils.UrlUtil;
import im.qingtui.qbee.open.platfrom.base.model.enums.HttpRequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.auth.model.vo.menu.AuthMenuTree;
import im.qingtui.qbee.open.platfrom.auth.model.vo.menu.EmployeeMenuTree;
import im.qingtui.qbee.open.platfrom.auth.model.vo.menu.authnode.AuthNodeInfo;
import im.qingtui.qbee.open.platfrom.auth.model.vo.menu.authnode.BaseAuthNode;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseResult;

import java.util.List;

import lombok.val;

import static im.qingtui.qbee.open.platfrom.auth.common.constants.UrlConstants.*;

/**
 * 菜单相关接口
 *
 * @author shizhen
 */
public class MenuService {

    /**
     * 获取角色的菜单权限树（不带token,取配置文件的服务号信息获取token）
     *
     * @param getRoleAuthMenuParam 获取角色的菜单权限树参数
     * @return 角色的菜单权限树
     */
    public static BaseList<AuthMenuTree> getRoleAuthMenuTree(GetRoleAuthMenuParam getRoleAuthMenuParam) {
        return getRoleAuthMenuTree(getRoleAuthMenuParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseList<AuthMenuTree> getRoleAuthMenuTree(GetRoleAuthMenuParam getRoleAuthMenuParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, UrlUtil
            .getOpenUrl(GET_ROLE_AUTH_MENU_TREE_URL), token, getRoleAuthMenuParam);
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<AuthMenuTree>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 编辑角色的菜单权限
     *
     * @param editRoleAuthMenuParam 编辑角色的菜单权限参数
     */
    public static void editRoleAuthMenu(EditRoleAuthMenuParam editRoleAuthMenuParam) {
        HttpClientRequestUtils.putRequest(UrlUtil.getOpenUrl(EDIT_ROLE_AUTH_MENU_URL), TokenUtils.getToken(), editRoleAuthMenuParam);
    }

    /**
     * 根据员工id获取员工的菜单信息树
     *
     * @param getEmployeeMenuParam 获取员工的菜单信息参数
     * @return 员工的菜单信息树
     */
    public static BaseList<EmployeeMenuTree> getEmployeeMenuTree(GetEmployeeMenuParam getEmployeeMenuParam) {
        return getEmployeeMenuTree(getEmployeeMenuParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseList<EmployeeMenuTree> getEmployeeMenuTree(GetEmployeeMenuParam getEmployeeMenuParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, UrlUtil.getApiUrl(GET_EMPLOYEE_MENU_URL), token, getEmployeeMenuParam);
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<EmployeeMenuTree>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 获取某用户在某菜单（当前菜单节点）下的所有权限节点-菜单编码获取
     *
     * @param param MenuIdParam
     * @return 权限节点列表
     */
    public static List<BaseAuthNode> listByMenu(MenuIdParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(UrlUtil.getOpenUrl(MENU_LIST_ID_URL), TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<BaseAuthNode>>() {
        });
        return BaseList.getData(data);
    }

    /**
     * 获取某用户在某菜单（当前菜单节点）下的所有权限节点-菜单编码获取
     *
     * @param param MenuCodeParam
     * @return 权限节点列表
     */
    public static List<BaseAuthNode> listByMenu(MenuCodeParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(UrlUtil.getOpenUrl(MENU_LIST_CODE_URL), TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<BaseAuthNode>>() {
        });
        return BaseList.getData(data);
    }

    /**
     * 获取某用户在某菜单（当前菜单节点）下的所有权限节点-菜单编码获取
     *
     * @param param MenuEmployeeIdParam
     * @return 权限节点列表
     */
    public static List<AuthNodeInfo> listByMenuEmployee(MenuEmployeeIdParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(UrlUtil.getOpenUrl(MENU_EMPLOYEE_LIST_ID_URL), TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<AuthNodeInfo>>() {
        });
        return BaseList.getData(data);
    }

    /**
     * 获取某用户在某菜单（当前菜单节点）下的所有权限节点-菜单编码获取
     *
     * @param param MenuEmployeeCodeParam
     * @return 权限节点列表
     */
    public static List<AuthNodeInfo> listByMenuEmployee(MenuEmployeeCodeParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(UrlUtil.getOpenUrl(MENU_EMPLOYEE_LIST_CODE_URL), TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<AuthNodeInfo>>() {
        });
        return BaseList.getData(data);
    }

    /**
     * 通过菜单id或编码获取授权的员工列表
     *
     * @param param GetAuthEmployeeParam
     * @return 授权员工列表
     */
    public static List<BaseInfo> listAuthEmployeeByMenuId(GetAuthEmployeeParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(UrlUtil.getOpenUrl(MENU_EMPLOYEE_AUTH_LIST_URL), TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<BaseInfo>>() {
        });
        return BaseList.getData(data);
    }
}