package im.qingtui.qbee.open.platfrom.auth.model.vo.role;

import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import java.io.Serializable;
import java.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 角色树返回信息
 *
 * @author shizhen
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class RoleTree extends BaseInfo implements Serializable {

    /**
     * 角色编码
     */
    String code;
    /**
     * 节点类型（0-是分组，1-是角色）
     */
    Integer type;
    /**
     * 子节点角色分组信息
     */
    List<RoleTree> children;

    @Override
    public String toString() {
        return "RoleTree{" +
            "code='" + code + '\'' +
            ", type=" + type +
            ", children=" + children +
            ", name='" + super.getName() + '\'' +
            ", id='" + super.getId() + '\'' +
            '}';
    }
}