package im.qingtui.qbee.open.platfrom.auth.model.vo.role;

import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 角色返回信息
 *
 * @author shizhen
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class RoleInfo extends BaseInfo implements Serializable {

    /**
     * 角色编码
     */
    String code;
    /**
     * 角色描述
     */
    String desc;
    /**
     * 角色有效性（0-无效，1-有效）
     */
    Integer valid;
    /**
     * 角色所属分组id
     */
    String groupId;

    @Override
    public String toString() {
        return "RoleInfo{" +
            "code='" + code + '\'' +
            ", desc='" + desc + '\'' +
            ", valid=" + valid +
            ", groupId='" + groupId + '\'' +
            ", name='" + super.getName() + '\'' +
            ", id='" + super.getId() + '\'' +
            '}';
    }
}