package im.qingtui.qbee.open.platfrom.auth.model.vo.menu;

import java.io.Serializable;
import java.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 员工菜单树返回信息
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class EmployeeMenuTree implements Serializable {

    /**
     * 菜单id
     */
    String menuId;
    /**
     * 菜单名称
     */
    String name;
    /**
     * 关联系统
     */
    String subSystem;
    /**
     * 跳转url
     */
    String linkUrl;
    /**
     * 子菜单信息列表
     */
    List<EmployeeMenuTree> children;

    /**
     * 菜单编码
     */
    String code;
}