package im.qingtui.qbee.open.platfrom.auth.model.vo.menu;

import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import java.io.Serializable;
import java.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.FieldDefaults;

/**
 * 权限菜单树
 *
 * @author shizhen
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
@ToString(callSuper = true)
public class AuthMenuTree extends BaseInfo implements Serializable {

    /**
     * 节点类型（0-权限，1-菜单）
     */
    String type;
    /**
     * 是否子节点全部选中(0-没有全部,1-全部选中)
     */
    Integer isSelected;
    /**
     * 子节点信息列表
     */
    List<AuthMenuTree> children;


}