package im.qingtui.qbee.open.platfrom.auth.model.param.menu;

import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 获取角色的菜单权限请求参数
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class GetRoleAuthMenuParam implements Serializable {

    /**
     * 角色id
     */
    String roleId;
    /**
     * 客户端类型(1-web端,2-移动端)
     */
    Integer clientType;
    /**
     * 是否展示全部菜单权限(0-只展示选中,1-展示全部菜单权限)
     */
    Integer all;
}