/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.qbee.open.platfrom.flow.util;

import com.alibaba.fastjson.JSONObject;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseResult;
import im.qingtui.qbee.open.platfrom.flow.model.param.FlowFileDownloadParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.FlowFileUploadParam;
import im.qingtui.qbee.open.platfrom.flow.model.vo.FlowFileVO;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpStreamUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpStreamUtils.class);

    public static Map<String, Object> getFileParam(String url) {
        File file = new File(url);
        String fileName = file.getName();
        byte[] buffer = new byte[]{};
        try {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int len = 0;
            byte[] b = new byte[1024];
            while ((len = in.read(b, 0, b.length)) != -1) {
                baos.write(b, 0, len);
            }
            buffer = baos.toByteArray();
        }
        catch (Exception e) {
            log.error("\u672a\u77e5\u9519\u8bef" + e.getMessage());
            e.printStackTrace();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fileName", fileName);
        map.put("buffer", buffer);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseHttpVO postUploadFile(String url, String token, FlowFileUploadParam flowFile) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        String info = "";
        BaseHttpVO baseHttpVO = null;
        try {
            String fileName = flowFile.getFileName();
            byte[] bytes = flowFile.getFile();
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody("file", bytes, ContentType.MULTIPART_FORM_DATA, fileName);
            builder.addTextBody("fileName", fileName);
            builder.addTextBody("employeeId", flowFile.getEmployeeId());
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            httpPost.addHeader("Authorization", token);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                info = EntityUtils.toString((HttpEntity)responseEntity, (Charset)Charset.forName("UTF-8"));
            }
            JSONObject value = JSONObject.parseObject((String)info);
            baseHttpVO = HttpStreamUtils.converterToVO(value.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return baseHttpVO;
    }

    public static FlowFileVO getFileStream(String url, String token, FlowFileDownloadParam fileDownloadParam) throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        url = url + "?employeeId=" + fileDownloadParam.getEmployeeId() + "&fileId=" + fileDownloadParam.getFileId();
        HttpGet get = new HttpGet(url);
        get.addHeader("Authorization", token);
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        String fileName = "";
        String type = "";
        FlowFileVO flowFileParam = new FlowFileVO();
        if (response.getHeaders("Content-Disposition").length > 0) {
            fileName = response.getHeaders("Content-Disposition")[0].getValue().split("filename=")[1];
            flowFileParam.setFileName(fileName);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            return null;
        }
        HttpEntity entity = response.getEntity();
        byte[] data = EntityUtils.toByteArray((HttpEntity)entity);
        flowFileParam.setFile(data);
        type = entity.getContentType().getValue();
        flowFileParam.setContentType(type);
        return flowFileParam;
    }

    private static BaseHttpVO converterToVO(String json) {
        log.debug(json);
        JSONObject infoJson = JSONObject.parseObject((String)json);
        BaseHttpVO vo = new BaseHttpVO();
        vo.setCode(Integer.valueOf(infoJson.getIntValue("code")));
        vo.setMessage(infoJson.getString("message"));
        if (vo.getCode() != 0 && vo.getCode() != 200) {
            throw new IllegalRequestException(new BaseResult(vo));
        }
        vo.setDataJson(infoJson.getJSONObject("data"));
        return vo;
    }
}

