package im.qingtui.qbee.open.platfrom.schedule.service;

import static im.qingtui.qbee.open.platfrom.schedule.model.constant.UrlConstant.TURN_PAGE_URL;
import static im.qingtui.qbee.open.platfrom.schedule.model.constant.UrlConstant.TURN_URL;

import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.utils.CollectionUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.model.param.base.IdListParam;
import im.qingtui.qbee.open.platfrom.base.model.param.base.PageParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BasePage;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.WorkTurnInfo;
import java.util.Collections;
import java.util.List;
import lombok.val;

/**
 * <p> title: 班次管理
 * <p> time: 2021/3/19 4:23 下午
 *
 * @author 阳君
 * @version 1.0
 */
public class WorkTurnService {

    /**
     * 通过班次 id 获取班次详情
     *
     * @param turnId 班次id
     * @return 班次信息
     */
    public static WorkTurnInfo getByTurnId(String turnId) {
        val list = listByTurnId(Collections.singletonList(turnId));
        return CollectionUtils.get(list, 0);
    }

    /**
     * 通过班次id批量获取班次详情
     *
     * @param turnIdList 班次id
     * @return List WorkTurnVO
     */
    public static List<WorkTurnInfo> listByTurnId(List<String> turnIdList) {
        val baseHttpVO = HttpClientRequestUtils.getRequest(TURN_URL, TokenUtils.getToken(), new IdListParam(turnIdList));
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<WorkTurnInfo>>() {
        });
        return BaseList.getData(data);
    }

    /**
     * 分页获取班次列表
     *
     * @param param 分页参数
     * @return 班次列表
     */
    public static BasePage<WorkTurnInfo> page(PageParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(TURN_PAGE_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BasePage<WorkTurnInfo>>() {
        });
    }

}
