package im.qingtui.qbee.open.platfrom.schedule.service;

import com.alibaba.fastjson.TypeReference;
import static im.qingtui.qbee.open.platfrom.schedule.model.constant.UrlConstant.*;
import im.qingtui.qbee.open.platfrom.base.common.utils.CollectionUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.model.param.base.IdListParam;
import im.qingtui.qbee.open.platfrom.base.model.param.base.PageParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BasePage;
import im.qingtui.qbee.open.platfrom.schedule.model.param.GroupTurnDateParam;
import im.qingtui.qbee.open.platfrom.schedule.model.param.GroupTurnDateRegionParam;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.WorkGroupInfo;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.WorkGroupTurnVO;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.WorkHolidayInfo;
import java.util.Collections;
import java.util.List;
import lombok.val;

/**
 * <p> title: 班组管理
 * <p> time: 2021/4/25 4:18 下午
 * <p> Copyright © 2010-2021 CISDI Info. All Rights Reserved.
 *
 * @author 阳君
 * @version 1.0.0
 */
public class WorkGroupService {

    /**
     * 通过班组 id 获取班组详情
     *
     * @param groupId 班组id
     * @return 班组信息
     */
    public static WorkGroupInfo getByGroupId(String groupId) {
        val list = listByGroupId(Collections.singletonList(groupId));
        return CollectionUtils.get(list, 0);
    }

    /**
     * 通过班组id批量获取班组详情
     *
     * @param groupIdList 班组id
     * @return List WorkTurnVO
     */
    public static List<WorkGroupInfo> listByGroupId(List<String> groupIdList) {
        val baseHttpVO = HttpClientRequestUtils.getRequest(GROUP_URL, TokenUtils.getToken(), new IdListParam(groupIdList));
        return HttpClientRequestUtils.convertToList(baseHttpVO, new TypeReference<BaseList<WorkGroupInfo>>() {
        });
    }

    /**
     * 获取排班组列表
     *
     * @param param 分页信息
     * @return 班组列表
     */
    public static BasePage<WorkGroupInfo> page(PageParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GROUP_PAGE_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BasePage<WorkGroupInfo>>() {
        });
    }

    /**
     * 根据日期查询排班信息
     *
     * @param gmtDate 时间戳 毫秒级
     * @return list
     */
    public static List<WorkGroupTurnVO> getGroupTurnByDate(String gmtDate) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GROUP_TURN_DATE_URL, TokenUtils.getToken(), new GroupTurnDateParam(gmtDate));
        return HttpClientRequestUtils.convertToList(baseHttpVO, new TypeReference<BaseList<WorkGroupTurnVO>>() {
        });
    }

    /**
     * 根据起止日期范围查询排班信息
     *
     * @param param 起止时间参数封装
     * @return list
     */
    public static List<WorkGroupTurnVO> listGroupTurnByDate(GroupTurnDateRegionParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GROUP_TURN_DATE_REGION_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToList(baseHttpVO, new TypeReference<BaseList<WorkGroupTurnVO>>() {
        });
    }

    /**
     * 通过节假日id获取节假日详情
     *
     * @param holidayId 节假日id
     * @return 节假日
     */
    public static WorkHolidayInfo getHolidayByHolidayId(String holidayId) {
        val list = listHolidayByHolidayId(Collections.singletonList(holidayId));
        return CollectionUtils.get(list, 0);
    }

    /**
     * 通过节假日id批量获取节假日详情
     *
     * @param holidayIdList 节假日id集合
     * @return 节假日
     */
    public static List<WorkHolidayInfo> listHolidayByHolidayId(List<String> holidayIdList) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(HOLIDAY_URL, TokenUtils.getToken(), new IdListParam(holidayIdList));
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<WorkHolidayInfo>>() {
        });
        return BaseList.getData(data);
    }

}
