package im.qingtui.qbee.open.platfrom.schedule.service;

import static im.qingtui.qbee.open.platfrom.schedule.model.constant.UrlConstant.EMPLOYEE_GROUP_TURN_LIST_URL;
import static im.qingtui.qbee.open.platfrom.schedule.model.constant.UrlConstant.EMPLOYEE_GROUP_TURN_URL;
import static im.qingtui.qbee.open.platfrom.schedule.model.constant.UrlConstant.EMPLOYEE_List_URL;

import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.model.param.base.IdParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeeBaseInfo;
import im.qingtui.qbee.open.platfrom.schedule.model.param.EmployeeGroupOrgParam;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.WorkGroupTurnListVO;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.WorkGroupTurnVO;
import java.util.List;
import lombok.val;

/**
 * <p> title: 员工排班
 * <p> time: 2021/4/25 4:18 下午
 * <p> Copyright © 2010-2021 CISDI Info. All Rights Reserved.
 *
 * @author 阳君
 * @version 1.0.0
 */
public class WorkEmployeeService {

    /**
     * 通过员工id获取当班信息
     *
     * @param employeeId 员工id
     * @return 当班班组
     */
    public static WorkGroupTurnVO getCurrentGroupTurn(String employeeId) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(EMPLOYEE_GROUP_TURN_URL, TokenUtils.getToken(), new IdParam(employeeId));
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<WorkGroupTurnVO>() {
        });
    }

    /**
     * 通过员工id获取排班信息
     *
     * @param employeeId 员工id
     * @return 工作组信息
     */
    public static WorkGroupTurnListVO listCurrentGroupTurn(String employeeId) {
        val baseHttpVO = HttpClientRequestUtils.getRequest(EMPLOYEE_GROUP_TURN_LIST_URL, TokenUtils.getToken(), new IdParam(employeeId));
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<WorkGroupTurnListVO>() {
        });
    }

    /**
     * 通过班组Id，组织机构Id获取人员列表
     *
     * @param param 组织id与班组id
     * @return 人员列表
     */
    public static List<EmployeeBaseInfo> listEmployeeByGroupIdAndOrgId(EmployeeGroupOrgParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(EMPLOYEE_List_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToList(baseHttpVO, new TypeReference<BaseList<EmployeeBaseInfo>>() {
        });
    }

}
