package im.qingtui.qbee.open.platfrom.schedule.model.vo;

import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import lombok.AccessLevel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.FieldDefaults;

/**
 * <p> title: 班次
 * <p> time: 2021/4/25 3:23 下午
 * <p> Copyright © 2010-2021 CISDI Info. All Rights Reserved.
 *
 * @author 阳君
 * @version 1.0.0
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@FieldDefaults(level = AccessLevel.PRIVATE)
public class WorkTurnInfo extends BaseInfo {

    /**
     * 班次名称
     */
    String name;
    /**
     * 班次的简称
     */
    String shortName;
    /**
     * 班次的颜色
     */
    String color;
    /**
     * 班次类型（1：普通班次 2：休息班次）
     */
    Integer turnType;
    /**
     * 班次启用状态（0：未启用 1：启用）
     */
    Boolean status;
    /**
     * 班次的开始时间（时间戳，日期固定为2000年1月1日）
     */
    Long gmtStart;
    /**
     * 班次结束时间（时间戳，日期固定为2000年1月1日-2日）
     */
    Long gmtEnd;
    /**
     * 编码
     */
    String code;

}
