package im.qingtui.qbee.open.platfrom.flow.service;

import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_AUTH_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_FILE_UPLOAD;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_INSTANCE_CLOSE_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_INSTANCE_INFO_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_NODE_LIST_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_NODE_OUTER_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_PROCESS_ENTITY_ATTR_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_PROCESS_ENTITY_DATA_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_PROCESS_ENTITY_PROC_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_PROCESS_ENTITY_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_RUNTIME_INSTANCE_BATCH_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_RUNTIME_INSTANCE_BPM_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_RUNTIME_INSTANCE_FLOW_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_RUNTIME_INSTANCE_PROCESS_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_RUNTIME_INSTANCE_START_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_RUNTIME_TASK_COMPLETE_BATCH_URL;
import static im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant.FLOW_RUNTIME_TASK_COMPLETE_URL;

import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseId;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BasePage;
import im.qingtui.qbee.open.platfrom.flow.model.constant.UrlConstant;
import im.qingtui.qbee.open.platfrom.flow.model.param.BaseFlowPageListParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.EndProcessInstanceParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.FlowFileDownloadParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.FlowFileUploadParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.FlowInstanceInfoParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.GetBatchFlowOpinionsParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.GetFlowAllNodeParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.GetFlowImageParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.GetFlowNodeFormUrlParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.GetFlowOpinionsParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.InitiationProcessParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.QueryBoEnAttrListParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.QueryEntityDataParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.QueryFlowBoEnListParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.QueryProcInstDataParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.TaskBatchCompleteParam;
import im.qingtui.qbee.open.platfrom.flow.model.param.TaskCompleteParam;
import im.qingtui.qbee.open.platfrom.flow.model.vo.BoEntityAttrVO;
import im.qingtui.qbee.open.platfrom.flow.model.vo.BoEntityReVO;
import im.qingtui.qbee.open.platfrom.flow.model.vo.FLowManageVO;
import im.qingtui.qbee.open.platfrom.flow.model.vo.FLowNodeVO;
import im.qingtui.qbee.open.platfrom.flow.model.vo.FlowFileVO;
import im.qingtui.qbee.open.platfrom.flow.model.vo.FlowImageVO;
import im.qingtui.qbee.open.platfrom.flow.model.vo.FlowInstanceVO;
import im.qingtui.qbee.open.platfrom.flow.model.vo.FlowNodeOuterFormVO;
import im.qingtui.qbee.open.platfrom.flow.model.vo.FlowOpinionsVO;
import im.qingtui.qbee.open.platfrom.flow.model.vo.FlowUploadFileVO;
import im.qingtui.qbee.open.platfrom.flow.model.vo.RowVO;
import im.qingtui.qbee.open.platfrom.flow.model.vo.TaskBatchCompleteVO;
import im.qingtui.qbee.open.platfrom.flow.util.HttpStreamUtils;
import java.util.HashMap;
import java.util.List;
import lombok.experimental.UtilityClass;
import lombok.val;

/**
 * <p> title: 流程引擎服务
 * <p> time: 2021/4/21 5:13 下午
 * <p> Copyright © 2010-2021 CISDI Info. All Rights Reserved.
 *
 * @author 阳君
 * @version 1.0.0
 */
@UtilityClass
public class FlowService {

    /**
     * 发起流程
     *
     * @param param InitiationProcessParam
     * @return 流程id
     */
    public String initiationProcess(InitiationProcessParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.postRequest(FLOW_RUNTIME_INSTANCE_START_URL, TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseId>() {
        });
        return data == null ? null : data.getId();
    }

    /**
     * 获取能发起的流程列表
     *
     * @param param BaseFlowPageListParam
     * @return BasePage FLowManageVO
     */
    public BasePage<FLowManageVO> pageProcess(BaseFlowPageListParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(FLOW_RUNTIME_INSTANCE_PROCESS_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BasePage<FLowManageVO>>() {
        });
    }

    /**
     * 获取流程图
     *
     * @param param GetFlowImageParam
     * @return FlowImageVO
     */
    public FlowImageVO getFlowImage(GetFlowImageParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(FLOW_RUNTIME_INSTANCE_BPM_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<FlowImageVO>() {
        });
    }

    /**
     * 获取流程审批步骤（此接口只返回已经审批和待审批的节点信息）
     *
     * @param param GetFlowOpinionsParam
     * @return List FlowOpinionsVO
     */
    public List<FlowOpinionsVO> listFlowOpinions(GetFlowOpinionsParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(FLOW_RUNTIME_INSTANCE_FLOW_URL, TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<FlowOpinionsVO>>() {
        });
        return BaseList.getData(data);
    }

    /**
     * 批量获取流程审批步骤（此接口只返回已经审批和待审批的节点信息）
     *
     * @param param GetBatchFlowOpinionsParam
     * @return List FlowOpinionsVO
     */
    public List<FlowOpinionsVO> listFlowBatchOpinions(GetBatchFlowOpinionsParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(FLOW_RUNTIME_INSTANCE_BATCH_URL, TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<FlowOpinionsVO>>() {
        });
        return BaseList.getData(data);
    }

    /**
     * 获取员工待办列表
     *
     * @param param BaseFlowPageListParam
     * @return BasePage RowVO
     */
    public BasePage<RowVO> pageTodo(BaseFlowPageListParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(UrlConstant.FLOW_RUNTIME_TASK_TODO_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BasePage<RowVO>>() {
        });
    }

    /**
     * 通用任务处理接口（同意、反对、驳回制定节点、驳回到发起人等）
     *
     * @param param TaskCompleteParam
     */
    public void taskComplete(TaskCompleteParam param) {
        HttpClientRequestUtils.postRequestJson(FLOW_RUNTIME_TASK_COMPLETE_URL, TokenUtils.getToken(), param);
    }

    /**
     * 通用任务批量处理（同意、反对）
     *
     * @param param TaskBatchCompleteParam
     * @return TaskBatchCompleteVO
     */
    public TaskBatchCompleteVO taskBatchComplete(TaskBatchCompleteParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.postRequestJson(FLOW_RUNTIME_TASK_COMPLETE_BATCH_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<TaskBatchCompleteVO>() {
        });
    }

    /**
     * 获取用户可配置的流程
     *
     * @param param BaseFlowPageListParam
     * @return BasePage FLowManageVO
     */
    public BasePage<FLowManageVO> pageAuthConfigProcess(BaseFlowPageListParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(FLOW_AUTH_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BasePage<FLowManageVO>>() {
        });
    }

    /**
     * 获取流程所有节点
     *
     * @param param GetFlowAllNodeParam
     * @return List FLowNodeVO
     */
    public List<FLowNodeVO> listFlowAllNode(GetFlowAllNodeParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(FLOW_NODE_LIST_URL, TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<FLowNodeVO>>() {
        });
        return BaseList.getData(data);
    }

    /**
     * 获取流程实例当前节点的外挂表单
     *
     * @param param GetFlowNodeFormUrlParam
     * @return FlowNodeOuterFormVO
     */
    public FlowNodeOuterFormVO getFlowAllNodeList(GetFlowNodeFormUrlParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(FLOW_NODE_OUTER_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<FlowNodeOuterFormVO>() {
        });
    }

    /**
     * 获取流程实例信息
     *
     * @param param FlowInstanceInfoParam
     * @return List FlowInstanceVO
     */
    public List<FlowInstanceVO> listInstanceInfo(FlowInstanceInfoParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(FLOW_INSTANCE_INFO_URL, TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<FlowInstanceVO>>() {
        });
        return BaseList.getData(data);
    }

    /**
     * 关闭未完成的流程实例
     *
     * @param param EndProcessInstanceParam
     */
    public void closeInstance(EndProcessInstanceParam param) {
        HttpClientRequestUtils.putRequest(FLOW_INSTANCE_CLOSE_URL, TokenUtils.getToken(), param);
    }

    /**
     * 获取流程绑定的模型实体列表
     *
     * @param param QueryFlowBoEnListParam
     * @return List BoEntityReVO
     */
    public List<BoEntityReVO> listProcessBindBoEntity(QueryFlowBoEnListParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(FLOW_PROCESS_ENTITY_URL, TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<BoEntityReVO>>() {
        });
        return BaseList.getData(data);
    }

    /**
     * 获取模型实体的属性
     *
     * @param param QueryBoEnAttrListParam
     * @return List BoEntityAttrVO
     */
    public List<BoEntityAttrVO> listProcessBindBoEntityAttr(QueryBoEnAttrListParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(FLOW_PROCESS_ENTITY_ATTR_URL, TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<BoEntityAttrVO>>() {
        });
        return BaseList.getData(data);
    }

    /**
     * 获取流程绑定的模型实体产生的数据
     *
     * @param param QueryEntityDataParam
     * @return List HashMap
     */
    public List<HashMap> listProcessBindBoEntityAttrData(QueryEntityDataParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(FLOW_PROCESS_ENTITY_DATA_URL, TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<HashMap>>() {
        });
        return BaseList.getData(data);
    }

    /**
     * 通过数据id和实例id获取某个数据详情
     *
     * @param param QueryProcInstDataParam
     * @return List HashMap
     */
    public List<HashMap> listProcessBindBoEntityAttrData(QueryProcInstDataParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequestJson(FLOW_PROCESS_ENTITY_PROC_URL, TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<HashMap>>() {
        });
        return BaseList.getData(data);
    }

    /**
     * 上传文件
     *
     * @param param FlowFileUploadParam
     */
    public String flowFileUpload(FlowFileUploadParam param) {
        BaseHttpVO baseHttpVO = HttpStreamUtils.postUploadFile(FLOW_FILE_UPLOAD, TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<FlowUploadFileVO>() {
        });
        return data == null ? null : data.getFileId();
    }

    /**
     * 下载文件
     *
     * @param param FlowFileDownloadParam
     */
    public FlowFileVO flowFileDownload(FlowFileDownloadParam param) throws Exception {
        return HttpStreamUtils.getFileStream(UrlConstant.FLOW_FILE_DOWNLOAD, TokenUtils.getToken(), param);
    }

}
