package im.qingtui.qbee.open.platfrom.flow.model.vo;

import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * <p> title: 模型的实体信息
 * <p> time: 2021/4/21 4:59 下午
 * <p> Copyright © 2010-2021 CISDI Info. All Rights Reserved.
 *
 * @author 阳君
 * @version 1.0.0
 */
@Data
@FieldDefaults(level = AccessLevel.PRIVATE)
public class BoEntityReVO implements Serializable {

    /**
     * 模型实体id
     */
    String entityId;

    /**
     * 模型实体描述
     */
    String description;

    /**
     * 模型实体是实体的关系 主表：main  从表一对一：onetoone  从表一对多：onetomany
     */
    String type;

    /**
     * 模型实体关系id
     */
    String id;

    /**
     * 模型实体父级实体id（也即主实体关系id）
     */
    String parentId;
}
