package im.qingtui.qbee.open.platfrom.drive.service;

import static im.qingtui.qbee.open.platfrom.drive.model.constant.UrlConstant.DRIVE_FOLDER_CHILDREN_URL;
import static im.qingtui.qbee.open.platfrom.drive.model.constant.UrlConstant.DRIVE_FOLDER_LIST_URL;
import static im.qingtui.qbee.open.platfrom.drive.model.constant.UrlConstant.DRIVE_FOLDER_URL;

import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.model.param.base.BaseKeywordParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.drive.model.param.folder.CreateFolderParam;
import im.qingtui.qbee.open.platfrom.drive.model.param.folder.FolderChildrenParam;
import im.qingtui.qbee.open.platfrom.drive.model.vo.folder.CreateFolderVO;
import im.qingtui.qbee.open.platfrom.drive.model.vo.folder.FolderVO;
import im.qingtui.qbee.open.platfrom.drive.model.vo.folder.SpaceVO;
import java.util.List;
import lombok.experimental.UtilityClass;
import lombok.val;

/**
 * <p> title: 文件夹管理
 * <p> time: 2021/4/15 10:35 上午
 *
 * @author 阳君
 * @version 1.0.0
 */
@UtilityClass
public class DriveFolderService {

    /**
     * 创建文件夹
     *
     * @param param CreateFolderParam
     * @return CreateFolderVO
     */
    public CreateFolderVO createFolder(CreateFolderParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.postRequest(DRIVE_FOLDER_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<CreateFolderVO>() {
        });
    }

    /**
     * 获取团队空间列表
     *
     * @param keyword 开放平台服务token
     * @return List BaseInfo
     */
    public List<SpaceVO> listSpaceByKeyword(String keyword) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(DRIVE_FOLDER_LIST_URL, TokenUtils.getToken(), new BaseKeywordParam(keyword));
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<SpaceVO>>() {
        });
        return BaseList.getData(data);
    }

    /**
     * 获取子文件夹列表
     *
     * @param param GetFolderChildrenParam
     * @return List FolderVO
     */
    public List<FolderVO> listChildrenByFolder(FolderChildrenParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(DRIVE_FOLDER_CHILDREN_URL, TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<FolderVO>>() {
        });
        return BaseList.getData(data);
    }

}
