/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.qbee.open.platfrom.schedule.service;

import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.utils.CollectionUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.DateUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.UrlUtil;
import im.qingtui.qbee.open.platfrom.base.model.param.base.IdListParam;
import im.qingtui.qbee.open.platfrom.base.model.param.base.PageParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BasePage;
import im.qingtui.qbee.open.platfrom.schedule.model.param.GroupTurnDateParam;
import im.qingtui.qbee.open.platfrom.schedule.model.param.GroupTurnDateRegionParam;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.WorkGroupInfo;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.WorkGroupTurnVO;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.WorkHolidayInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;

public class WorkGroupService {
    public static WorkGroupInfo getByGroupId(String groupId) {
        List<WorkGroupInfo> list = WorkGroupService.listByGroupId(Collections.singletonList(groupId));
        return (WorkGroupInfo)((Object)CollectionUtils.get(list, (int)0));
    }

    public static List<WorkGroupInfo> listByGroupId(List<String> groupIdList) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest((String)UrlUtil.getApiUrl((String)"/op/schedule/work/group"), (String)TokenUtils.getToken(), (Object)new IdListParam(groupIdList));
        return HttpClientRequestUtils.convertToList((BaseHttpVO)baseHttpVO, (TypeReference)new TypeReference<BaseList<WorkGroupInfo>>(){});
    }

    public static BasePage<WorkGroupInfo> page(PageParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest((String)UrlUtil.getApiUrl((String)"/op/schedule/work/group/page"), (String)TokenUtils.getToken(), (Object)param);
        return (BasePage)HttpClientRequestUtils.convertToData((BaseHttpVO)baseHttpVO, (TypeReference)new TypeReference<BasePage<WorkGroupInfo>>(){});
    }

    public static List<WorkGroupTurnVO> getGroupTurnByDate(String gmtDate) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest((String)UrlUtil.getApiUrl((String)"/op/schedule/work/group/turn/date"), (String)TokenUtils.getToken(), (Object)new GroupTurnDateParam(gmtDate));
        return HttpClientRequestUtils.convertToList((BaseHttpVO)baseHttpVO, (TypeReference)new TypeReference<BaseList<WorkGroupTurnVO>>(){});
    }

    public static List<WorkGroupTurnVO> listGroupTurnByTime(String gmtDate) {
        long gmtTime = Long.parseLong(gmtDate);
        ArrayList<WorkGroupTurnVO> result = new ArrayList<WorkGroupTurnVO>();
        if (DateUtils.distanceStartTime((long)gmtTime) < DateUtils.TWELVE_HOURS_MILLIS) {
            List<WorkGroupTurnVO> yesterdayList = WorkGroupService.getGroupTurnByDate(String.valueOf(gmtTime - DateUtils.TWELVE_HOURS_MILLIS));
            for (WorkGroupTurnVO item : yesterdayList) {
                if (!DateUtils.betweenTimeHms2((long)gmtTime, (long)item.getTurn().getGmtStart(), (long)item.getTurn().getGmtEnd())) continue;
                result.add(item);
            }
        }
        List<WorkGroupTurnVO> todayList = WorkGroupService.getGroupTurnByDate(gmtDate);
        for (WorkGroupTurnVO item : todayList) {
            if (!DateUtils.betweenTimeHms((long)gmtTime, (long)item.getTurn().getGmtStart(), (long)item.getTurn().getGmtEnd())) continue;
            result.add(item);
        }
        return result;
    }

    public static List<WorkGroupTurnVO> listGroupTurnByTimeRegex(String gmtDate, @NonNull String codeRegex) {
        if (codeRegex == null) {
            throw new NullPointerException("codeRegex is marked non-null but is null");
        }
        List<WorkGroupTurnVO> list = WorkGroupService.listGroupTurnByTime(gmtDate);
        return WorkGroupService.filterWorkGroupByCodeRegex(list, codeRegex);
    }

    public static List<WorkGroupTurnVO> filterWorkGroupByCodeRegex(List<WorkGroupTurnVO> list, @NonNull String codeRegex) {
        if (codeRegex == null) {
            throw new NullPointerException("codeRegex is marked non-null but is null");
        }
        return list.stream().filter(item -> Pattern.matches(codeRegex, item.getGroup().getCode())).collect(Collectors.toList());
    }

    public static List<WorkGroupTurnVO> listGroupTurnByDate(GroupTurnDateRegionParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest((String)UrlUtil.getApiUrl((String)"/op/schedule/work/group/turn/date/region"), (String)TokenUtils.getToken(), (Object)param);
        return HttpClientRequestUtils.convertToList((BaseHttpVO)baseHttpVO, (TypeReference)new TypeReference<BaseList<WorkGroupTurnVO>>(){});
    }

    public static WorkHolidayInfo getHolidayByHolidayId(String holidayId) {
        List<WorkHolidayInfo> list = WorkGroupService.listHolidayByHolidayId(Collections.singletonList(holidayId));
        return (WorkHolidayInfo)((Object)CollectionUtils.get(list, (int)0));
    }

    public static List<WorkHolidayInfo> listHolidayByHolidayId(List<String> holidayIdList) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest((String)UrlUtil.getApiUrl((String)"/op/schedule/work/holiday"), (String)TokenUtils.getToken(), (Object)new IdListParam(holidayIdList));
        BaseList data = (BaseList)HttpClientRequestUtils.convertToData((BaseHttpVO)baseHttpVO, (TypeReference)new TypeReference<BaseList<WorkHolidayInfo>>(){});
        return BaseList.getData((BaseList)data);
    }
}

