package im.qingtui.qbee.open.platfrom.schedule.model.vo;

import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import java.util.List;
import lombok.AccessLevel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.FieldDefaults;

/**
 * <p> title: 班组
 * <p> time: 2021/4/25 3:22 下午
 * <p> Copyright © 2010-2021 CISDI Info. All Rights Reserved.
 *
 * @author 阳君
 * @version 1.0.0
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@FieldDefaults(level = AccessLevel.PRIVATE)
public class WorkGroupInfo extends BaseInfo {

    /**
     * 创建者id
     */
    String creatorId;
    /**
     * 班次类型,1-固定班次,2-排班制
     */
    Integer type;
    /**
     * 生效日期
     */
    Long gmtEffect;
    /**
     * 组织机构id列表
     */
    List<String> orgIdList;
    /**
     * 用户id列表
     */
    List<String> employeeIdList;
    /**
     * 特殊用户id列表
     */
    List<String> specialEmployeeIdList;
    /**
     * 班次id列表
     */
    List<String> turnIdList;
    /**
     * 排班周期id列表
     */
    List<String> cycleTurnIdList;
    /**
     * 上班时间,周一到周日，1-7
     */
    List<String> workDayList;
    /**
     * 编码
     */
    String code;

}
