package im.qingtui.qbee.open.platfrom.flow.util;

import com.alibaba.fastjson.JSONObject;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseResult;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseVO;
import im.qingtui.qbee.open.platfrom.flow.model.param.FlowFileDownloadParam;
import im.qingtui.qbee.open.platfrom.flow.model.vo.FlowFileVO;
import im.qingtui.qbee.open.platfrom.flow.model.param.FlowFileUploadParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;

import java.io.*;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

import static im.qingtui.qbee.open.platfrom.base.common.constants.TokenConstants.*;

@Slf4j
public final class HttpStreamUtils {

    public static Map<String, Object> getFileParam(String url) {
        File file = new File(url);
        String fileName = file.getName();
        byte[] buffer = new byte[0];
        try {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int len = 0;
            byte[] b = new byte[1024];
            while ((len = in.read(b, 0, b.length)) != -1) {
                baos.write(b, 0, len);
            }
            buffer = baos.toByteArray();
        } catch (Exception e) {
            log.error("未知错误" + e.getMessage());
            e.printStackTrace();
        }
        Map<String, Object> map = new HashMap<>();
        map.put("fileName", fileName);
        map.put("buffer", buffer);
        return map;
    }

    public static BaseHttpVO postUploadFile(String url, String token, FlowFileUploadParam flowFile) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        String info = "";
        BaseHttpVO baseHttpVO = null;
        try {
            String fileName = flowFile.getFileName();
            byte[] bytes = flowFile.getFile();
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            //设置中文编码
            builder.setCharset(StandardCharsets.UTF_8);
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            //构建请求体
            builder.addBinaryBody("file", bytes, ContentType.MULTIPART_FORM_DATA, fileName);
            builder.addTextBody("fileName", fileName,ContentType.create(HTTP.PLAIN_TEXT_TYPE, HTTP.UTF_8));
            builder.addTextBody("employeeId", flowFile.getEmployeeId());
            HttpEntity entity = builder.build();

            httpPost.setEntity(entity);
            httpPost.addHeader("Authorization", token);
            HttpResponse response = httpClient.execute(httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                info = EntityUtils.toString(responseEntity, Charset.forName("UTF-8"));
            }
            Object value = JSONObject.parseObject(info);
            baseHttpVO = converterToVO(value.toString());
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                httpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return baseHttpVO;
    }

    public static FlowFileVO getFileStream(String url, String token, FlowFileDownloadParam fileDownloadParam) throws Exception {
        //发起下载请求
        CloseableHttpClient client = HttpClients.createDefault();
        url = url + "?employeeId=" + fileDownloadParam.getEmployeeId() + "&fileId=" + fileDownloadParam.getFileId();
        HttpGet get = new HttpGet(url);
        get.addHeader("Authorization", token);
        HttpResponse response = client.execute(get);
        String fileName = "", type = "";
        //获取返回参数
        FlowFileVO flowFileParam = new FlowFileVO();
        if (response.getHeaders("Content-Disposition").length > 0) {
            fileName = response.getHeaders("Content-Disposition")[0].getValue().split("filename=")[1];
            fileName = URLDecoder.decode(fileName,"utf-8");
            flowFileParam.setFileName(fileName);
        }
        if (response.getStatusLine().getStatusCode() == 200) {
            HttpEntity entity = response.getEntity();
            byte[] data = EntityUtils.toByteArray(entity);
            flowFileParam.setFile(data);
            type = entity.getContentType().getValue();
            flowFileParam.setContentType(type);
        } else {
            return null;
        }
        return flowFileParam;
    }

    private static BaseHttpVO converterToVO(String json) {
        log.debug(json);
        JSONObject infoJson = JSONObject.parseObject(json);
        BaseHttpVO vo = new BaseHttpVO();
        vo.setCode(infoJson.getIntValue(CODE));
        vo.setMessage(infoJson.getString(MESSAGE));
        if (vo.getCode() != 0 && vo.getCode() != 200) {
            throw new IllegalRequestException(new BaseResult(vo));
        }
        vo.setDataJson(infoJson.getJSONObject(DATA));
        return vo;
    }

}
