package im.qingtui.qbee.open.platfrom.flow.model.vo;

import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseTypeInfo;
import lombok.AccessLevel;
import lombok.Data;
import lombok.experimental.FieldDefaults;

import java.io.Serializable;
import java.util.List;

/**
 * <p> title: 流程审批返回信息
 * <p> time: 2021/4/21 4:59 下午
 * <p> Copyright © 2010-2021 CISDI Info. All Rights Reserved.
 *
 * @author 阳君
 * @version 1.0.0
 */
@Data
@FieldDefaults(level = AccessLevel.PRIVATE)
public class FlowOpinionsVO implements Serializable {

    /**
     * 审批流程id
     */
    String id;
    /**
     * 审批流程创建时间
     */
    String createTime;
    /**
     * 审批流程模板id
     */
    String procModuleId;
    /**
     * 任务key值
     */
    String taskKey;
    /**
     * 任务名称
     */
    String taskName;
    /**
     * 审核人id
     */
    String auditorId;
    /**
     * 审核人姓名
     */
    String auditorName;
    /**
     * 审核意见
     */
    String opinion;
    /**
     * 当前节点审批状态
     */
    String status;
    /**
     * 审批流程完成时间
     */
    String completeTime;

    /**
     * 当前节点处理情况
     */
    String statusVal;
    /**
     * 审批节点id
     */
    String taskId;

    /**
     * 待审批人
     */
    String qualfiedNames;
    /**
     *审核人信息
     */
    List<BaseTypeInfo> qualifiedList;

    /**
     * 是否已读
     */
    Integer isRead;

    /**
     *分配时间
     */
    String assignTime;
}