package im.qingtui.qbee.open.platfrom.flow.model.vo;

import java.io.Serializable;
import lombok.AccessLevel;
import lombok.Data;
import lombok.experimental.FieldDefaults;

/**
 * <p> title: 流程实例当前信息列表
 * <p> time: 2021/4/21 4:59 下午
 * <p> Copyright © 2010-2021 CISDI Info. All Rights Reserved.
 *
 * @author 阳君
 * @version 1.0.0
 */
@Data
@FieldDefaults(level = AccessLevel.PRIVATE)
public class FlowInstanceVO implements Serializable {

    /**
     * 当前流程实例id
     */
    String instanceId;

    /**
     * 流程实例id
     */
    String procInstId;

    /**
     * 流程发起标题
     */
    String subject;

    /**
     * 当前流程实例状态（draft：草稿，running：运行中，end：结束， manualend：人工结束，backToStart：驳回到发起人，back：驳回，revoke：撤销，revokeToStart：撤销到发起人）
     */
    String instanceStatus;

    /**
     * 当前流程实例的当前节点id
     */
    String currentNodeId;

    /**
     * 当前流程实例的当前节点名字
     */
    String currentNodeName;

    /**
     * 流程实例最新任务id
     */
    String taskId;

    /**
     * 流程id
     */
    String defId;


}
