package im.qingtui.qbee.open.platfrom.flow.model.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 已办的信息
 * @author mengtian
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DoneRowVO extends RowVO implements Serializable {


    /**
     * 流程实例id
     */
    private String bpmnInstId;

    /**
     * 发起的流程id
     */
    private String procDefId;

    /**
     * 当前用户完成此任务的时间（时间戳）
     */
    private String taskCompleteTime;

    /**
     * 当前任务的创建时间
     */
    private String taskCreateTime;

    /**
     * 任务所处理的流程节点id
     */
    private String taskKey;

    /**
     * 任务被处理用户id
     */
    private String updateBy;

}