package im.qingtui.qbee.open.platfrom.flow.model.vo;

import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * <p> title: 模型实体属性
 * <p> time: 2021/4/21 4:59 下午
 * <p> Copyright © 2010-2021 CISDI Info. All Rights Reserved.
 *
 * @author 阳君
 * @version 1.0.0
 */
@Data
@FieldDefaults(level = AccessLevel.PRIVATE)
public class BoEntityAttrVO implements Serializable {

    /**
     * 属性id
     */
    String id;

    /**
     * 属性名字
     */
    String name;

    /**
     * 属性描述
     */
    String description;

    /**
     * 属性类型（date-日期 string-字符串 text-大文本 number-数字）
     */
    String type;

    /**
     * 格式
     */
    String format;

    /**
     * 默认值
     */
    String defaultValue;

    /**
     * 是否必填（0：非必填 1：必填）
     */
    Integer required;

    /**
     * 长度
     */
    Integer length;

    /**
     * 对应表的字段名
     */
    String fieldName;
}
