package im.qingtui.qbee.open.platfrom.flow.model.param;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

import java.util.List;

/**
 * <p> title:
 * <p> time: 2021/6/10 10:21
 * <p> Copyright © 2010-2021 CISDI Info. All Rights Reserved.
 *
 * @author 潘俊丞
 * @version 1.0.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class TaskUpdateExecutorParam{
    /**
     * 任务id
     */
    String taskId;
    /**
     * 通知类型: voice: 语音, mail: 邮件,
     *         qbee: 轻蜂, sms: 短信, inner: 站内消息
     */
    List<String> messageType;
    /**
     * 转办人名称
     */
    List<String> receiverNames;
    /**
     * 转办人id集合
     */
    List<String> userIds;
    /**
     * 通知内容
     */
    String cause;
    /**
     * 操作人id
     */
    String employeeId;
}
