package im.qingtui.qbee.open.platfrom.flow.model.param;


import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.experimental.FieldDefaults;

/**
 * <p> title: 任务处理参数
 * <p> time: 2021/4/21 4:59 下午
 * <p> Copyright © 2010-2021 CISDI Info. All Rights Reserved.
 *
 * @author 阳君
 * @version 1.0.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class TaskCompleteParam {

    /**
     * 员工id
     */
    String employeeId;
    /**
     * 操作类型 agree（同意）, oppose（反对）, backToStart（退回到开始节点），reject（退回到指定节点）
     */
    @NonNull
    String actionName = "agree";
    /**
     * 处理数据
     */
    @NonNull
    String data = "";
    /**
     * 处理目的
     */
    String destination = "";
    /**
     * 处理文件
     */
    String files = "";
    /**
     * 单签流程的表单类型
     */
    String fromType = "inner";
    /**
     * 跳转类型
     */
    String jumpType = "";
    /**
     * 节点用户
     */
    List<String> nodeUsers = new ArrayList<>();
    /**
     * 处理类型
     */
    @NonNull
    String opinion = "";
    /**
     * 任务id
     */
    @NonNull
    String taskId;

    /**
     * 退回模式, 重新审批-normal，回到本节点-direct
     */
    String backHandMode = "direct";

    /**
     * url表单参数
     */
    Map<String,String> vars;
}