package im.qingtui.qbee.open.platfrom.flow.model.param;


import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.experimental.FieldDefaults;

/**
 * <p> title: 查询模型实体数据参数
 * <p> time: 2021/4/21 4:59 下午
 * <p> Copyright © 2010-2021 CISDI Info. All Rights Reserved.
 *
 * @author 阳君
 * @version 1.0.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class QueryEntityDataParam {

    /**
     * 需要查询实体数据的流程key
     */
    @NonNull
    String defKey;

    /**
     * 需要查询的实体id
     */
    @NonNull
    String entityId;

    /**
     * 下一页id，第一次请求传0
     */
    String nextId = "0";

    /**
     * 请求每页打大小
     */
    Integer size = 100;

}
