package im.qingtui.qbee.open.platfrom.flow.model.param;

import im.qingtui.qbee.open.platfrom.base.model.param.base.PageParam;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.experimental.FieldDefaults;

/**
 * <p> title: 流程引擎获取列表参数
 * <p> time: 2021/4/21 4:59 下午
 * <p> Copyright © 2010-2021 CISDI Info. All Rights Reserved.
 *
 * @author 阳君
 * @version 1.0.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class BaseFlowPageListParam extends PageParam {

    /**
     * 操作者员工id
     */
    @NonNull
    String employeeId;
    /**
     * 搜索关键字
     */
    String keyword;

    /**
     * 分类关键字
     */
    String group;

}