package im.qingtui.qbee.open.platfrom.drive.service;

import static im.qingtui.qbee.open.platfrom.drive.model.constant.UrlConstant.DRIVE_FILE_DOWNLOAD_URL;
import static im.qingtui.qbee.open.platfrom.drive.model.constant.UrlConstant.DRIVE_FILE_LIST_URL;
import static im.qingtui.qbee.open.platfrom.drive.model.constant.UrlConstant.DRIVE_FILE_UPLOAD_URL;
import static im.qingtui.qbee.open.platfrom.drive.model.constant.UrlConstant.DRIVE_FILE_URL;

import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.UrlUtil;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BasePage;
import im.qingtui.qbee.open.platfrom.drive.model.param.file.FileDownloadParam;
import im.qingtui.qbee.open.platfrom.drive.model.param.file.FileListParam;
import im.qingtui.qbee.open.platfrom.drive.model.param.file.FileSaveParam;
import im.qingtui.qbee.open.platfrom.drive.model.param.file.UploadSignatureParam;
import im.qingtui.qbee.open.platfrom.drive.model.vo.file.FileDownloadVO;
import im.qingtui.qbee.open.platfrom.drive.model.vo.file.FileVO;
import im.qingtui.qbee.open.platfrom.drive.model.vo.file.SaveFileVO;
import im.qingtui.qbee.open.platfrom.drive.model.vo.file.SignatureVO;
import lombok.experimental.UtilityClass;
import lombok.val;

/**
 * <p> title: 文件管理
 * <p> time: 2021/4/15 10:36 上午
 *
 * @author 阳君
 * @version 1.0.0
 */
@UtilityClass
public class DriveFileService {

    /**
     * 获取文件上传签名
     *
     * @param param UploadSignatureParam
     * @return SignatureVO
     */
    public SignatureVO getFileUploadSignature(UploadSignatureParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(UrlUtil.getOpenUrl(DRIVE_FILE_UPLOAD_URL), TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<SignatureVO>() {
        });
    }

    /**
     * 保存文件信息
     *
     * @param fileKey 文件 key,获取文件上传签名返回的 key
     * @return SaveFileVO
     */
    public SaveFileVO saveFile(String fileKey) {
        val param = new FileSaveParam(fileKey);
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.postRequest(UrlUtil.getOpenUrl(DRIVE_FILE_URL), TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<SaveFileVO>() {
        });
    }

    /**
     * 获取下载文件地址
     *
     * @param param GetFileDownloadParam
     * @return 下载地址
     */
    public String getFileDownloadUrl(FileDownloadParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(UrlUtil.getOpenUrl(DRIVE_FILE_DOWNLOAD_URL), TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<FileDownloadVO>() {
        });
        return data == null ? null : data.getUrl();
    }

    /**
     * 获取文件夹下的文件列表
     *
     * @param param FileListParam
     * @return 文件列表
     */
    public BasePage<FileVO> listFile(FileListParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(UrlUtil.getOpenUrl(DRIVE_FILE_LIST_URL), TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BasePage<FileVO>>() {
        });
    }

}
