package im.qingtui.qbee.open.platfrom.drive.model.param.file;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.experimental.FieldDefaults;

/**
 * 获取上传签名参数
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class UploadSignatureParam {

    /**
     * 文件名
     */
    @NonNull
    String fileName;
    /**
     * 空间id/文件夹id
     */
    @NonNull
    String folderId;
    /**
     * 文件大小
     */
    @NonNull
    Long size;
    /**
     * 文件类型
     */
    @NonNull
    String contentType;
    /**
     * 业务编码
     */
    String businessCode;
}