package im.qingtui.qbee.open.platfrom.communication.service;

import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.UrlUtil;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.communication.model.param.MobileSmsParam;
import im.qingtui.qbee.open.platfrom.communication.model.param.MobileVmsParam;
import im.qingtui.qbee.open.platfrom.communication.model.param.MobileVmsRetryParam;
import im.qingtui.qbee.open.platfrom.communication.model.vo.CallResultInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.office.TakeOfficeInfo;
import lombok.val;

import java.util.List;
import java.util.Objects;

import static im.qingtui.qbee.open.platfrom.communication.model.constant.UrlConstant.*;

/**
 * [Description] 移动消息服务
 *
 * @author QingSong
 * @version 1.0
 * @since 2021-09-17 11:16
 */
public class MobileService {

    /**
     * 发送短消息
     *
     * @param smsParam 短信参数
     */
    public static void sendSms(MobileSmsParam smsParam) {
        HttpClientRequestUtils.postRequestJson(UrlUtil.getOpenUrl(SEND_SMS_URL), TokenUtils.getToken(), smsParam);
    }

    /**
     * 发送语音电话
     *
     * @param vmsParam 语音电话
     */
    public static void sendVms(MobileVmsParam vmsParam) {
        HttpClientRequestUtils.postRequestJson(UrlUtil.getOpenUrl(SEND_VMS_URL), TokenUtils.getToken(), vmsParam);
    }
    /**
      *发送语音重试
     * @param vmsRetryParam 语音电话重试参数
      */
    public static List<CallResultInfo> sendRetryVms(MobileVmsRetryParam vmsRetryParam) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.postRequestJson(UrlUtil.getOpenUrl(SEND_VMS_RETRY_URL), TokenUtils.getToken(), vmsRetryParam);
        return Objects.requireNonNull(HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<CallResultInfo>>() {
        })).getList();
    }

}
